/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Computer;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.Language;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;
import org.eclipse.persistence.testing.models.aggregate.Responsibility;

public class DescriptorRefreshCacheTest
extends ReadObjectTest {
    public ClassDescriptor resDescriptor;
    public ClassDescriptor langDescriptor;
    public ClassDescriptor comDescriptor;
    public ClassDescriptor empDescriptor;

    public DescriptorRefreshCacheTest(Object originalObject) {
        this.setOriginalObject(originalObject);
        this.setName("DescriptorRefreshCacheTest(" + originalObject.getClass() + ")");
        this.setDescription("This test case tests refresh cache hit property on descriptor.");
    }

    protected void changeObject(Employee employee) {
        employee.setFirstName("Zack");
        ProjectDescription projectDescription = employee.getProjectDescription();
        projectDescription.setDescription("FBI Project");
        ((Vector)projectDescription.getResponsibilities().getValue()).removeElement(((Vector)projectDescription.getResponsibilities().getValue()).firstElement());
        ((Vector)projectDescription.getResponsibilities().getValue()).addElement(Responsibility.example1(employee));
        ((Vector)projectDescription.getResponsibilities().getValue()).addElement(Responsibility.example2(employee));
        ((Vector)projectDescription.getLanguages().getValue()).removeElement(((Vector)projectDescription.getLanguages().getValue()).firstElement());
        ((Vector)projectDescription.getLanguages().getValue()).addElement(Language.example1());
        ((Vector)projectDescription.getLanguages().getValue()).addElement(Language.example2());
        ((Computer)projectDescription.getComputer().getValue()).setDescription("Newton");
    }

    public void reset() {
        this.empDescriptor.dontAlwaysRefreshCache();
        this.empDescriptor.dontDisableCacheHits();
        this.resDescriptor.dontAlwaysRefreshCache();
        this.langDescriptor.dontAlwaysRefreshCache();
        this.comDescriptor.dontAlwaysRefreshCache();
        this.comDescriptor.dontDisableCacheHits();
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.empDescriptor = this.getSession().getClassDescriptor(Employee.class);
        this.resDescriptor = this.getSession().getClassDescriptor(Responsibility.class);
        this.langDescriptor = this.getSession().getClassDescriptor(Language.class);
        this.comDescriptor = this.getSession().getClassDescriptor(Computer.class);
        this.empDescriptor.alwaysRefreshCache();
        this.empDescriptor.disableCacheHits();
        this.resDescriptor.alwaysRefreshCache();
        this.langDescriptor.alwaysRefreshCache();
        this.comDescriptor.alwaysRefreshCache();
        this.comDescriptor.disableCacheHits();
        this.objectFromDatabase = this.getSession().readObject(this.originalObject);
    }

    public void test() {
        Employee originalState = (Employee)this.objectFromDatabase;
        String originalFirstName = originalState.getFirstName();
        String originalProjectDescription = originalState.getProjectDescription().getDescription();
        Vector originalResponsibilities = (Vector)((Vector)originalState.getProjectDescription().getResponsibilities().getValue()).clone();
        Vector originalLanguages = (Vector)((Vector)originalState.getProjectDescription().getLanguages().getValue()).clone();
        Computer originalComputer = (Computer)originalState.getProjectDescription().getComputer().getValue();
        String originalComputerDescription = originalComputer.getDescription();
        this.changeObject(originalState);
        Employee employee = (Employee)this.getSession().readObject((Object)originalState);
        if (employee != originalState) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        if (originalComputer != employee.getProjectDescription().getComputer().getValue()) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        Enumeration enumtr = originalResponsibilities.elements();
        while (enumtr.hasMoreElements()) {
            Responsibility responsibility = (Responsibility)enumtr.nextElement();
            if (((Collection)employee.getProjectDescription().getResponsibilities().getValue()).contains(responsibility)) continue;
            throw new TestErrorException("Always refresh cache does not work.");
        }
        enumtr = originalLanguages.elements();
        while (enumtr.hasMoreElements()) {
            Language language = (Language)enumtr.nextElement();
            if (((Collection)employee.getProjectDescription().getLanguages().getValue()).contains(language)) continue;
            throw new TestErrorException("Always refresh cache does not work.");
        }
        ProjectDescription projectDescription = employee.getProjectDescription();
        Vector responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        Computer computer = (Computer)projectDescription.getComputer().getValue();
        if (!employee.getFirstName().equals(originalFirstName)) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        if (!projectDescription.getDescription().equals(originalProjectDescription)) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        if (responsibilities.size() != originalResponsibilities.size()) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        if (languages.size() != originalLanguages.size()) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
        if (!computer.getDescription().equals(originalComputerDescription)) {
            throw new TestErrorException("Always refresh cache does not work.");
        }
    }
}

