/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.insurance;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public abstract class Policy
implements Serializable {
    private long policyNumber;
    private float maxCoverage = 0.0f;
    private String description = "";
    private Vector claims = new Vector();
    private PolicyHolder policyHolder;

    public Claim addClaim(Claim claim) {
        this.getClaims().addElement(claim);
        claim.setPolicy(this);
        return claim;
    }

    public Vector getClaims() {
        return this.claims;
    }

    public String getDescription() {
        return this.description;
    }

    public float getMaxCoverage() {
        return this.maxCoverage;
    }

    public PolicyHolder getPolicyHolder() {
        return this.policyHolder;
    }

    public long getPolicyNumber() {
        return this.policyNumber;
    }

    public Claim removeClaim(Claim claim) {
        this.getClaims().removeElement(claim);
        claim.setPolicy(null);
        return claim;
    }

    public void setClaims(Vector claims) {
        this.claims = claims;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxCoverage(float maxCoverage) {
        this.maxCoverage = maxCoverage;
    }

    public void setPolicyHolder(PolicyHolder policyHolder) {
        this.policyHolder = policyHolder;
    }

    public void setPolicyNumber(long policyNumber) {
        this.policyNumber = policyNumber;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + ": " + this.getPolicyNumber();
    }
}

