/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;

public abstract class ConcurrentPerformanceRegressionTest
extends PerformanceRegressionTestCase {
    public static int DEFAULT_THREADS = 32;
    protected int maxThreads = DEFAULT_THREADS;
    protected Exception caughtException;
    protected List<WorkerThread> workerThreads;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public synchronized void incrementIterations() {
        ++this.iterations;
    }

    @Override
    public synchronized void resetIterations() {
        this.iterations = 0;
    }

    @Override
    public void startTest() {
        this.startTest(this.getMaxThreads());
    }

    public void startTest(int numberOfThreads) {
        this.caughtException = null;
        for (int index = 0; index < numberOfThreads - 1; ++index) {
            WorkerThread thread = this.getWorkerThreads().get(index);
            thread.resumeExecution();
        }
    }

    @Override
    public void endTest() {
        WorkerThread thread;
        int index;
        for (index = 0; index < this.getMaxThreads(); ++index) {
            thread = this.getWorkerThreads().get(index);
            thread.suspendExecution();
        }
        Thread.yield();
        for (index = 0; index < this.getMaxThreads(); ++index) {
            thread = this.getWorkerThreads().get(index);
            thread.joinExecution();
        }
    }

    public List<WorkerThread> getWorkerThreads() {
        return this.workerThreads;
    }

    @Override
    public void setup() {
        this.workerThreads = new ArrayList<WorkerThread>(this.getMaxThreads());
        for (int index = 0; index < this.getMaxThreads(); ++index) {
            WorkerThread thread = new WorkerThread();
            this.workerThreads.add(thread);
            thread.start();
        }
    }

    @Override
    public void test() throws Exception {
        this.test(this.getMaxThreads());
    }

    public void test(int numberOfThreads) throws Exception {
        if (this.caughtException != null) {
            throw this.caughtException;
        }
        this.runTask();
    }

    @Override
    public void reset() {
        for (int index = 0; index < this.getWorkerThreads().size(); ++index) {
            WorkerThread thread = this.getWorkerThreads().get(index);
            thread.stopExecution();
        }
        Thread.yield();
        this.workerThreads = null;
    }

    public abstract void runTask() throws Exception;

    protected class WorkerThread
    extends Thread {
        protected boolean isSuspended = true;
        protected boolean isDead = false;

        protected WorkerThread() {
        }

        public void stopExecution() {
            this.isDead = true;
        }

        public void suspendExecution() {
            this.isSuspended = true;
        }

        public synchronized void joinExecution() {
            if (!this.isSuspended) {
                throw new RuntimeException("Must suspend first");
            }
        }

        public synchronized void resumeExecution() {
            this.isSuspended = false;
            try {
                this.notify();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }

        @Override
        public synchronized void run() {
            try {
                while (!this.isDead) {
                    if (this.isSuspended) {
                        this.wait();
                    }
                    ConcurrentPerformanceRegressionTest.this.runTask();
                    ConcurrentPerformanceRegressionTest.this.incrementIterations();
                }
            }
            catch (Exception exception) {
                ConcurrentPerformanceRegressionTest.this.caughtException = exception;
            }
        }
    }
}

