/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.corba.annotation.processing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.glassfish.pfl.basic.logex.ExceptionWrapper;
import org.glassfish.pfl.basic.logex.Message;

class FileGenerator {
    private Element classElement;
    private Date creationDate;
    private List<Element> methodElements = new ArrayList<Element>();

    FileGenerator(Element classElement, Date creationDate) {
        this.classElement = classElement;
        this.creationDate = creationDate;
    }

    String getPrefix() {
        ExceptionWrapper wrapper = this.classElement.getAnnotation(ExceptionWrapper.class);
        return wrapper.idPrefix();
    }

    FileObject createResource(Filer filer) throws IOException {
        return filer.createResource(StandardLocation.CLASS_OUTPUT, this.getPackage(), this.getName() + ".properties", new Element[0]);
    }

    void addMethod(Element methodElement) {
        this.methodElements.add(methodElement);
    }

    String getPackage() {
        return this.classElement.getEnclosingElement().toString();
    }

    private String getName() {
        return this.classElement.getSimpleName().toString();
    }

    boolean shouldWriteFile() {
        return !this.methodElements.isEmpty();
    }

    void writePropertyFileHeader(Writer writer) throws IOException {
        writer.append("### Resource file generated on ").append(this.creationDate.toString()).append('\n');
        writer.append("#\n");
        writer.append("# Resources for class ").append(this.classElement.toString()).append('\n');
        writer.append("#\n");
    }

    void writePropertyLines(Writer writer) throws IOException {
        for (Element methodElement : this.methodElements) {
            this.writePropertyLine(writer, methodElement);
        }
    }

    private void writePropertyLine(Writer writer, Element methodElement) throws IOException {
        writer.append('.').append(methodElement.getSimpleName()).append("=\"").append(this.getPrefix()).append(": ").append(this.getMessage(methodElement)).append("\"\n");
    }

    private String getMessage(Element methodElement) {
        return methodElement.getAnnotation(Message.class).value();
    }

    void writeContents(Writer writer) throws IOException {
        this.writePropertyFileHeader(writer);
        this.writePropertyLines(writer);
        writer.close();
    }

    void writeFile(Filer filer) throws IOException {
        FileObject file = this.createResource(filer);
        this.writeContents(file.openWriter());
    }
}

