/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.IdentityColumnInfo;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordEvolver;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.table.Table;

public class TableEvolver
extends TableBuilderBase {
    private final TableImpl table;
    private final int evolvedVersion;
    private String description;

    private TableEvolver(TableImpl table) {
        super(table.getFieldMap().clone());
        this.table = table;
        this.ttl = table.getDefaultTTL();
        this.description = table.getDescription();
        this.evolvedVersion = table.getTableVersion();
        if (this.evolvedVersion != table.numTableVersions()) {
            throw new IllegalArgumentException("Table evolution must be performed on the latest version");
        }
    }

    public static TableEvolver createTableEvolver(Table table) {
        return new TableEvolver(((TableImpl)table).clone());
    }

    @Override
    public String getBuilderType() {
        return "Evolver";
    }

    public TableImpl getTable() {
        return this.table;
    }

    public int getTableVersion() {
        return this.evolvedVersion;
    }

    public RecordDefImpl getRecord(String fieldName) {
        return (RecordDefImpl)this.getField(fieldName);
    }

    public MapDefImpl getMap(String fieldName) {
        return (MapDefImpl)this.getField(fieldName);
    }

    public ArrayDefImpl getArray(String fieldName) {
        return (ArrayDefImpl)this.getField(fieldName);
    }

    public RecordEvolver createRecordEvolver(RecordDefImpl record) {
        if (record == null) {
            throw new IllegalArgumentException("Null record passed to createRecordEvolver");
        }
        return new RecordEvolver(record);
    }

    @Override
    public TableBuilderBase setDescription(String description) {
        this.description = description;
        return this;
    }

    public TableImpl evolveTable() {
        if (this.hasSetIdentity) {
            this.table.evolve(this.fields, this.ttl, this.description, this.getIdentityColumnInfo(), this.sequenceDef);
        } else if (this.table.hasIdentityColumn()) {
            String idColName = this.table.getFieldMap().getFieldName(this.table.getIdentityColumn());
            if (!this.fields.exists(idColName)) {
                this.table.evolve(this.fields, this.ttl, this.description, null, null);
            } else {
                this.table.evolve(this.fields, this.ttl, this.description, new IdentityColumnInfo(this.fields.getFieldPos(idColName), this.table.getIdentityColumnInfo().isIdentityGeneratedAlways(), this.table.getIdentityColumnInfo().isIdentityOnNull()), null);
            }
        } else {
            this.table.evolve(this.fields, this.ttl, this.description, null, null);
        }
        this.fields = this.fields.clone();
        return this.table;
    }

    public String toJsonString(boolean pretty) {
        TableImpl t = this.table.clone();
        t.evolve(this.fields, this.ttl, this.description, this.getIdentityColumnInfo(), this.sequenceDef);
        return t.toJsonString(pretty);
    }

    @Override
    void validateFieldAddition(String fieldName, String pathName, FieldMapEntry field) {
        super.validateFieldAddition(fieldName, pathName, field);
        this.table.validateFieldAddition(pathName, field);
    }

    @Override
    void validateFieldRemoval(TablePath tablePath) {
        if (this.table.isKeyComponent(tablePath.getPathName())) {
            throw new IllegalArgumentException("Cannot remove a primary key field: " + tablePath.getPathName());
        }
        if (this.table.isIndexKeyComponent(tablePath)) {
            throw new IllegalArgumentException("Cannot remove an index key field: " + tablePath.getPathName());
        }
    }
}

