/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class ParallelBuilderReportItemTest
extends ReportQueryTestCase {
    public ParallelBuilderReportItemTest() {
        this.setDescription("ReportItems originating from parallel builders.");
    }

    @Override
    protected void buildExpectedResults() throws Exception {
        ExpressionBuilder husbandsAndWives = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder spouses = new ExpressionBuilder(Employee.class);
        Expression expression = husbandsAndWives.get("lastName").equal(spouses.get("lastName"));
        expression = expression.and(husbandsAndWives.get("gender").notEqual(spouses.get("gender")));
        query.setSelectionCriteria(expression);
        query.addOrdering(husbandsAndWives.get("lastName").ascending());
        query.addOrdering(husbandsAndWives.get("gender").descending());
        Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee husband = (Employee)e.nextElement();
            Employee wife = (Employee)e.nextElement();
            Object[] result = new Object[]{husband.getFirstName(), wife.getFirstName(), husband.getLastName(), wife.getLastName(), husband.getGender(), wife.getGender(), husband.getSalary(), wife.getSalary()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        ExpressionBuilder husbands = new ExpressionBuilder();
        ExpressionBuilder wives = new ExpressionBuilder(Employee.class);
        this.reportQuery = new ReportQuery(husbands);
        Expression expression = husbands.get("lastName").equal(wives.get("lastName"));
        expression = expression.and(husbands.get("gender").equal((Object)"Male").and(wives.get("gender").equal((Object)"Female")));
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("husband firstName", husbands.get("firstName"));
        this.reportQuery.addAttribute("wife firstName", wives.get("firstName"));
        this.reportQuery.addAttribute("husband lastName", husbands.get("lastName"));
        this.reportQuery.addAttribute("wife lastName", wives.get("lastName"));
        this.reportQuery.addAttribute("husband gender", husbands.get("gender"));
        this.reportQuery.addAttribute("wife gender", wives.get("gender"));
        this.reportQuery.addAttribute("husband salary", husbands.get("salary"));
        this.reportQuery.addAttribute("wife salary", wives.get("salary"));
        this.reportQuery.addOrdering(wives.get("lastName").ascending());
        this.reportQuery.setSelectionCriteria(expression);
    }
}

