/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.sql.Date;
import java.sql.Time;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RefreshTest
extends TestCase {
    protected Employee employeeObject;
    protected String city;
    protected String managerName;
    protected int collectionSize;
    protected Time startTime;
    protected Date endDate;
    protected int responsibilityListSize;

    public RefreshTest() {
        this.setDescription("This test verifies the refresh feature works properly");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.employeeObject = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Charles"));
    }

    public void test() throws Exception {
        this.city = this.employeeObject.getAddress().getCity();
        this.employeeObject.getAddress().setCity("Chelmsford");
        this.startTime = this.employeeObject.getStartTime();
        this.employeeObject.setStartTime(null);
        this.endDate = this.employeeObject.getPeriod().getEndDate();
        this.employeeObject.getPeriod().setEndDate(null);
        this.managerName = this.employeeObject.getManager().getFirstName();
        this.employeeObject.getManager().setFirstName("Karl");
        this.collectionSize = this.employeeObject.getPhoneNumbers().size();
        this.employeeObject.getPhoneNumbers().removeAllElements();
        this.responsibilityListSize = this.employeeObject.getResponsibilitiesList().size();
        this.employeeObject.getResponsibilitiesList().removeAllElements();
        this.getSession().refreshObject((Object)this.employeeObject);
    }

    protected void verify() throws Exception {
        if (!this.employeeObject.getAddress().getCity().equals(this.city)) {
            throw new TestErrorException("The refresh test failed.");
        }
        if (!this.employeeObject.getPeriod().getEndDate().equals(this.endDate)) {
            throw new TestErrorException("The refresh test failed.");
        }
        if (!this.employeeObject.getManager().getFirstName().equals("Karl")) {
            throw new TestErrorException("The refresh test failed.");
        }
        if (this.employeeObject.getPhoneNumbers().size() != this.collectionSize) {
            throw new TestErrorException("The refresh test failed.");
        }
        if (this.employeeObject.getResponsibilitiesList().size() != this.responsibilityListSize) {
            throw new TestErrorException("The refresh test failed.");
        }
    }
}

