/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.multipletable;

import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.models.multipletable.Cow;
import org.eclipse.persistence.testing.models.multipletable.Horse;
import org.eclipse.persistence.testing.models.multipletable.Human;
import org.eclipse.persistence.testing.models.multipletable.MultipleTableSystem;
import org.eclipse.persistence.testing.models.multipletable.SuperCow;
import org.eclipse.persistence.testing.models.multipletable.SuperHorse;
import org.eclipse.persistence.testing.models.multipletable.SuperSwan;
import org.eclipse.persistence.testing.models.multipletable.Swan;
import org.eclipse.persistence.testing.tests.multipletable.MultipleTableTest;

public class MultipleTableModel
extends TestModel {
    public MultipleTableModel() {
        this.setDescription("This model tests multiple tables.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new MultipleTableSystem());
    }

    public void addTests() {
        MultipleTableModel.addTestsToTestCollection((TestCollection)this);
    }

    public static void addTestsToTestCollection(TestCollection collection) {
        collection.addTest((Test)new ReadAllTest(Cow.class));
        collection.addTest((Test)new ReadAllTest(SuperCow.class));
        collection.addTest((Test)new ReadAllTest(Horse.class));
        collection.addTest((Test)new ReadAllTest(SuperHorse.class));
        collection.addTest((Test)new ReadAllTest(Swan.class));
        collection.addTest((Test)new ReadAllTest(SuperSwan.class));
        collection.addTest((Test)MultipleTableModel.getCowTest());
        collection.addTest((Test)MultipleTableModel.getSuperCowTest());
        collection.addTest((Test)MultipleTableModel.getHorseTest());
        collection.addTest((Test)MultipleTableModel.getSuperHorseTest());
        collection.addTest((Test)MultipleTableModel.getSwanTest());
        collection.addTest((Test)MultipleTableModel.getSuperSwanTest());
        collection.addTest((Test)MultipleTableModel.getHumanTest());
    }

    public static MultipleTableTest getCowTest() {
        Cow cow = new Cow();
        cow.setCalfCountId(101);
        cow.setCalfCount(18);
        cow.setAgeId(102);
        cow.setAge(10);
        cow.setWeightId(103);
        cow.setWeight(500);
        cow.setName("Lucky");
        return new MultipleTableTest(cow);
    }

    public static MultipleTableTest getSuperCowTest() {
        SuperCow cow = new SuperCow();
        cow.setCalfCountId(201);
        cow.setCalfCount(18);
        cow.setAgeId(202);
        cow.setAge(10);
        cow.setWeightId(203);
        cow.setWeight(500);
        cow.setSpeed(25);
        cow.setName("SuperLucky");
        return new MultipleTableTest(cow);
    }

    public static MultipleTableTest getHorseTest() {
        Horse horse = new Horse();
        horse.setFoalCount(9);
        horse.setAge(10);
        horse.setWeight(500);
        horse.setName("Pinky");
        return new MultipleTableTest(horse);
    }

    public static MultipleTableTest getSuperHorseTest() {
        SuperHorse horse = new SuperHorse();
        horse.setFoalCount(9);
        horse.setAge(10);
        horse.setWeight(500);
        horse.setSpeed(25);
        horse.setName("SuperPinky");
        return new MultipleTableTest(horse);
    }

    public static MultipleTableTest getSwanTest() {
        Swan swan = new Swan();
        swan.setCygnetCount(24);
        swan.setAge(10);
        swan.setWeight(500);
        swan.setName("Naws");
        return new MultipleTableTest(swan);
    }

    public static MultipleTableTest getSuperSwanTest() {
        SuperSwan swan = new SuperSwan();
        swan.setCygnetCount(24);
        swan.setAge(10);
        swan.setWeight(500);
        swan.setSpeed(25);
        swan.setName("RepusNaws");
        return new MultipleTableTest(swan);
    }

    public static MultipleTableTest getHumanTest() {
        Human human = new Human();
        human.setKidCount(2);
        human.setName("Wayne");
        return new MultipleTableTest(human);
    }

    public static class ReadAllTest
    extends TestCase {
        Class<?> cls;

        public ReadAllTest(Class<?> cls) {
            this.setName(Helper.getShortClassName(cls) + "ReadAllTest");
            this.cls = cls;
        }

        public void test() {
            this.getSession().readAllObjects(this.cls);
        }
    }
}

