/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.jaxb.AccessorFactoryWrapper;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.w3c.dom.Element;

public class CompilerHelper {
    public static final String XML_LOCATION_ANNOTATION_NAME = "org.glassfish.jaxb.core.annotation.XmlLocation";
    public static final String OLD_XML_LOCATION_ANNOTATION_NAME = "com.sun.xml.bind.annotation.XmlLocation";
    public static final String INTERNAL_XML_LOCATION_ANNOTATION_NAME = "com.sun.xml.internal.bind.annotation.XmlLocation";
    private static final String XML_ACCESSOR_FACTORY_ANNOTATION_NAME = "org.glassfish.jaxb.runtime.XmlAccessorFactory";
    private static final String OLD_ACCESSOR_FACTORY_ANNOTATION_NAME = "com.sun.xml.bind.XmlAccessorFactory";
    private static final String INTERNAL_ACCESSOR_FACTORY_ANNOTATION_NAME = "com.sun.xml.internal.bind.XmlAccessorFactory";
    private static final String METADATA_MODEL_PACKAGE = "org.eclipse.persistence.jaxb.xmlmodel";
    public static Class<?> ACCESSOR_FACTORY_ANNOTATION_CLASS = null;
    public static Method ACCESSOR_FACTORY_VALUE_METHOD = null;
    public static Class<?> OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS = null;
    public static Method OLD_ACCESSOR_FACTORY_VALUE_METHOD = null;
    public static Class<?> INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS = null;
    public static Method INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD = null;
    public static Class<?> XML_LOCATION_ANNOTATION_CLASS = null;
    public static Class<?> OLD_XML_LOCATION_ANNOTATION_CLASS = null;
    public static Class<?> INTERNAL_XML_LOCATION_ANNOTATION_CLASS = null;
    private static JAXBContext xmlBindingsModelContext;

    static Class<?> getExisitingGeneratedClass(TypeMappingInfo tmi, Map<TypeMappingInfo, Class<?>> typeMappingInfoToGeneratedClasses, Map<TypeMappingInfo, Class<?>> typeMappingInfoToAdapterClasses, ClassLoader loader) {
        for (Map.Entry<TypeMappingInfo, Class<?>> next : typeMappingInfoToGeneratedClasses.entrySet()) {
            TypeMappingInfo nextTMI = next.getKey();
            if (!CompilerHelper.generatesSameComplexType(tmi, nextTMI, loader)) continue;
            return next.getValue();
        }
        return null;
    }

    private static boolean generatesSameComplexType(TypeMappingInfo tmi1, TypeMappingInfo tmi2, ClassLoader loader) {
        Type actualType2;
        Type actualType1;
        org.eclipse.persistence.jaxb.xmlmodel.XmlElement element1 = null;
        org.eclipse.persistence.jaxb.xmlmodel.XmlElement element2 = null;
        if (tmi1.getXmlElement() != null) {
            element1 = CompilerHelper.getXmlElement(tmi1.getXmlElement(), loader);
        }
        if (tmi2.getXmlElement() != null) {
            element2 = CompilerHelper.getXmlElement(tmi2.getXmlElement(), loader);
        }
        if (!CompilerHelper.areTypesEqual(actualType1 = CompilerHelper.getActualType(tmi1, element1), actualType2 = CompilerHelper.getActualType(tmi2, element2))) {
            return false;
        }
        if (!CompilerHelper.hasSameClassName(tmi1, tmi2)) {
            return false;
        }
        boolean isXmlList1 = CompilerHelper.isXmlList(tmi1, element1);
        boolean isXmlList2 = CompilerHelper.isXmlList(tmi2, element2);
        return !(isXmlList1 ? !isXmlList2 : isXmlList2);
    }

    private static boolean hasSameClassName(TypeMappingInfo tmi1, TypeMappingInfo tmi2) {
        String typeName2;
        String typeName1;
        Type type1 = tmi1.getType();
        Type type2 = tmi2.getType();
        if (type1 != null && type2 == null) {
            return false;
        }
        if (type1 == null && type2 != null) {
            return false;
        }
        return !(type1 instanceof Class) || !(type2 instanceof Class) || (typeName1 = ((Class)type1).getName()).equals(typeName2 = ((Class)type2).getName());
    }

    private static boolean isXmlList(TypeMappingInfo tmi, org.eclipse.persistence.jaxb.xmlmodel.XmlElement element) {
        if (element != null && element.isXmlList()) {
            return true;
        }
        if (tmi.getAnnotations() != null) {
            for (int i = 0; i < tmi.getAnnotations().length; ++i) {
                Annotation nextAnnotation = tmi.getAnnotations()[i];
                if (nextAnnotation == null || !(nextAnnotation instanceof XmlList)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areTypesEqual(Type type, Type type2) {
        if (type == null) {
            return type2 == null;
        }
        if (type instanceof Class) {
            if (type2 instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type2).getRawType();
                if (!CompilerHelper.areTypesEqual(type, rawType)) {
                    return false;
                }
                Type[] args = ((ParameterizedType)type2).getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type argType = CompilerHelper.getActualArgumentType(args[i]);
                    if (CompilerHelper.areTypesEqual(Object.class, argType)) continue;
                    return false;
                }
                return true;
            }
            if (type2 instanceof Class) {
                return type.equals(type2);
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            if (type2 instanceof Class) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (!CompilerHelper.areTypesEqual(type2, rawType)) {
                    return false;
                }
                Type[] args = ((ParameterizedType)type).getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type argType = CompilerHelper.getActualArgumentType(args[i]);
                    if (CompilerHelper.areTypesEqual(Object.class, argType)) continue;
                    return false;
                }
                return true;
            }
            if (type2 instanceof ParameterizedType) {
                Type[] ta2;
                if (!CompilerHelper.areTypesEqual(((ParameterizedType)type).getRawType(), ((ParameterizedType)type2).getRawType())) {
                    return false;
                }
                Type[] ta1 = ((ParameterizedType)type).getActualTypeArguments();
                if (ta1.length != (ta2 = ((ParameterizedType)type2).getActualTypeArguments()).length) {
                    return false;
                }
                for (int i = 0; i < ta1.length; ++i) {
                    Type componentType2;
                    Type componentType1 = CompilerHelper.getActualArgumentType(ta1[i]);
                    if (CompilerHelper.areTypesEqual(componentType1, componentType2 = CompilerHelper.getActualArgumentType(ta2[i]))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static Type getActualArgumentType(Type argument) {
        if (argument instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)argument).getUpperBounds();
            if (upperBounds != null && upperBounds.length > 0) {
                return upperBounds[0];
            }
            return Object.class;
        }
        if (argument instanceof GenericArrayType) {
            return ((GenericArrayType)argument).getGenericComponentType();
        }
        return argument;
    }

    static org.eclipse.persistence.jaxb.xmlmodel.XmlElement getXmlElement(Element xmlElementNode, ClassLoader classLoader) {
        try {
            JAXBUnmarshaller unmarshaller = CompilerHelper.getXmlBindingsModelContext().createUnmarshaller();
            JAXBElement jelt = unmarshaller.unmarshal(xmlElementNode, org.eclipse.persistence.jaxb.xmlmodel.XmlElement.class);
            return (org.eclipse.persistence.jaxb.xmlmodel.XmlElement)jelt.getValue();
        }
        catch (JAXBException jaxbEx) {
            throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)jaxbEx));
        }
    }

    static Class<?> getTypeFromAdapterClass(Class<?> adapterClass) {
        if (adapterClass != null) {
            Class declJavaType = Object.class;
            Method[] tacMethods = PrivilegedAccessHelper.getMethods(adapterClass);
            for (int i = 0; i < tacMethods.length; ++i) {
                Class returnType;
                Method method = tacMethods[i];
                if (!method.getName().equals("marshal") || (returnType = PrivilegedAccessHelper.getMethodReturnType((Method)method)) == declJavaType) continue;
                declJavaType = returnType;
                return declJavaType;
            }
            return declJavaType;
        }
        return null;
    }

    public static JavaClass getTypeFromAdapterClass(JavaClass adapterClass, Helper helper) {
        if (adapterClass != null) {
            JavaClass declJavaType = helper.getJavaClass(Object.class);
            Object[] tacMethods = adapterClass.getMethods().toArray();
            for (int i = 0; i < tacMethods.length; ++i) {
                JavaClass returnType;
                JavaMethod method = (JavaMethod)tacMethods[i];
                if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(declJavaType.getQualifiedName())) continue;
                declJavaType = returnType;
                return declJavaType;
            }
            return declJavaType;
        }
        return null;
    }

    private static boolean isCollectionType(Type theType) {
        if (theType instanceof Class) {
            return Collection.class.isAssignableFrom((Class)theType) || List.class.isAssignableFrom((Class)theType) || Set.class.isAssignableFrom((Class)theType);
        }
        if (theType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)theType).getRawType();
            return CompilerHelper.isCollectionType(rawType);
        }
        return false;
    }

    static Type getActualType(TypeMappingInfo tmi, org.eclipse.persistence.jaxb.xmlmodel.XmlElement element) {
        try {
            if (element == null) {
                if (tmi.getAnnotations() != null) {
                    for (int i = 0; i < tmi.getAnnotations().length; ++i) {
                        Class typeClass;
                        Annotation nextAnnotation = tmi.getAnnotations()[i];
                        if (nextAnnotation == null) continue;
                        if (nextAnnotation instanceof XmlJavaTypeAdapter) {
                            typeClass = ((XmlJavaTypeAdapter)nextAnnotation).type();
                            if (typeClass.getName().equals("jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter$DEFAULT")) {
                                Class adapterClass = ((XmlJavaTypeAdapter)nextAnnotation).value();
                                return CompilerHelper.getTypeFromAdapterClass(adapterClass);
                            }
                            return typeClass;
                        }
                        if (!(nextAnnotation instanceof XmlElement) || (typeClass = ((XmlElement)nextAnnotation).type()).getName().equals("jakarta.xml.bind.annotation.XmlElement.DEFAULT")) continue;
                        final Type tmiType = tmi.getType();
                        if (CompilerHelper.isCollectionType(tmiType)) {
                            final Class itemType = typeClass;
                            ParameterizedType parameterizedType = new ParameterizedType(){
                                Type[] typeArgs;
                                {
                                    this.typeArgs = new Type[]{itemType};
                                }

                                @Override
                                public Type[] getActualTypeArguments() {
                                    return this.typeArgs;
                                }

                                @Override
                                public Type getOwnerType() {
                                    return null;
                                }

                                @Override
                                public Type getRawType() {
                                    return tmiType;
                                }
                            };
                            return parameterizedType;
                        }
                        return typeClass;
                    }
                }
                return tmi.getType();
            }
            if (element.getXmlJavaTypeAdapter() != null) {
                String actualType = element.getXmlJavaTypeAdapter().getType();
                if (actualType != null && !actualType.equals("jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                    return PrivilegedAccessHelper.getClassForName((String)actualType);
                }
                String adapterClassName = element.getXmlJavaTypeAdapter().getValue();
                Class adapterClass = PrivilegedAccessHelper.getClassForName((String)adapterClassName);
                return CompilerHelper.getTypeFromAdapterClass(adapterClass);
            }
            if (!element.getType().equals("jakarta.xml.bind.annotation.XmlElement.DEFAULT")) {
                String actualType = element.getType();
                final Type tmiType = tmi.getType();
                if (CompilerHelper.isCollectionType(tmiType)) {
                    final Class itemType = PrivilegedAccessHelper.getClassForName((String)actualType);
                    ParameterizedType parameterizedType = new ParameterizedType(){
                        Type[] typeArgs;
                        {
                            this.typeArgs = new Type[]{itemType};
                        }

                        @Override
                        public Type[] getActualTypeArguments() {
                            return this.typeArgs;
                        }

                        @Override
                        public Type getOwnerType() {
                            return null;
                        }

                        @Override
                        public Type getRawType() {
                            return tmiType;
                        }
                    };
                    return parameterizedType;
                }
                return PrivilegedAccessHelper.getClassForName((String)actualType);
            }
            return tmi.getType();
        }
        catch (Exception e) {
            return tmi.getType();
        }
    }

    public static JAXBContext getXmlBindingsModelContext() {
        if (xmlBindingsModelContext == null) {
            try {
                xmlBindingsModelContext = (JAXBContext)JAXBContextFactory.createContext(METADATA_MODEL_PACKAGE, CompilerHelper.class.getClassLoader());
            }
            catch (JAXBException e) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotCreateContextForXmlModel((Exception)((Object)e));
            }
            if (xmlBindingsModelContext == null) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotCreateContextForXmlModel();
            }
        }
        return xmlBindingsModelContext;
    }

    public static JavaClass getNextMappedSuperClass(JavaClass cls, Map<String, TypeInfo> typeInfo, Helper helper) {
        JavaClass superClass = cls.getSuperclass();
        if (superClass == null || helper.isBuiltInJavaType(cls) || superClass.getRawName().equals("java.lang.Object")) {
            return null;
        }
        TypeInfo parentTypeInfo = typeInfo.get(superClass.getQualifiedName());
        if (parentTypeInfo == null || parentTypeInfo.isTransient()) {
            return CompilerHelper.getNextMappedSuperClass(superClass, typeInfo, helper);
        }
        return superClass;
    }

    public static void addClassToClassLoader(JavaClass cls, ClassLoader loader) {
        if (loader.getClass() == JaxbClassLoader.class && cls.getClass() == JavaClassImpl.class) {
            Class<?> wrappedClass = ((JavaClassImpl)cls).getJavaClass();
            ((JaxbClassLoader)loader).putClass(wrappedClass.getName(), wrappedClass);
        }
    }

    static boolean hasNonAttributeJoinNodes(Property property) {
        block4: {
            block3: {
                if (!property.isSetXmlJoinNodes()) break block3;
                for (XmlJoinNodes.XmlJoinNode next : property.getXmlJoinNodes().getXmlJoinNode()) {
                    if (next.getXmlPath().startsWith("@")) continue;
                    return true;
                }
                break block4;
            }
            if (!property.isSetXmlJoinNodesList()) break block4;
            for (XmlJoinNodes nextNodes : property.getXmlJoinNodesList()) {
                for (XmlJoinNodes.XmlJoinNode next : nextNodes.getXmlJoinNode()) {
                    if (next.getXmlPath().startsWith("@")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Object createAccessorFor(JavaClass jClass, Property property, Helper helper, AccessorFactoryWrapper accessorFactory) {
        if (jClass.getClass() != JavaClassImpl.class) {
            return null;
        }
        Class<?> beanClass = ((JavaClassImpl)jClass).getJavaClass();
        if (property.isMethodProperty()) {
            try {
                Method getMethod = null;
                Method setMethod = null;
                if (property.getGetMethodName() != null) {
                    getMethod = PrivilegedAccessHelper.getMethod(beanClass, (String)property.getGetMethodName(), (Class[])new Class[0], (boolean)true);
                }
                if (property.getSetMethodName() != null) {
                    String setMethodParamTypeName = property.getType().getName();
                    JavaClassImpl paramType = (JavaClassImpl)helper.getJavaClass(setMethodParamTypeName);
                    Class[] setMethodParams = new Class[]{paramType.getJavaClass()};
                    setMethod = PrivilegedAccessHelper.getMethod(beanClass, (String)property.getSetMethodName(), (Class[])setMethodParams, (boolean)true);
                }
                return accessorFactory.createPropertyAccessor(beanClass, getMethod, setMethod);
            }
            catch (Exception getMethod) {}
        } else {
            try {
                Field field = PrivilegedAccessHelper.getField(beanClass, (String)((JavaField)property.getElement()).getName(), (boolean)true);
                return accessorFactory.createFieldAccessor(beanClass, field, property.isReadOnly());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isSimpleType(TypeInfo info) {
        if (info.isEnumerationType()) {
            return true;
        }
        Property xmlValueProperty = info.getXmlValueProperty();
        boolean hasMappedAttributes = false;
        for (Property nextProp : info.getPropertyList()) {
            if (!nextProp.isAttribute() || nextProp.isTransient()) continue;
            hasMappedAttributes = true;
        }
        hasMappedAttributes = hasMappedAttributes || info.hasPredicateProperties();
        return xmlValueProperty != null && !hasMappedAttributes;
    }

    static {
        try {
            ACCESSOR_FACTORY_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)XML_ACCESSOR_FACTORY_ANNOTATION_NAME, (boolean)true, (ClassLoader)CompilerHelper.class.getClassLoader());
            ACCESSOR_FACTORY_VALUE_METHOD = PrivilegedAccessHelper.getDeclaredMethod(ACCESSOR_FACTORY_ANNOTATION_CLASS, (String)"value", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            XML_LOCATION_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)XML_LOCATION_ANNOTATION_NAME, (boolean)true, (ClassLoader)CompilerHelper.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            OLD_XML_LOCATION_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)OLD_XML_LOCATION_ANNOTATION_NAME, (boolean)true, (ClassLoader)CompilerHelper.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)OLD_ACCESSOR_FACTORY_ANNOTATION_NAME);
            OLD_ACCESSOR_FACTORY_VALUE_METHOD = PrivilegedAccessHelper.getDeclaredMethod(OLD_ACCESSOR_FACTORY_ANNOTATION_CLASS, (String)"value", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)INTERNAL_ACCESSOR_FACTORY_ANNOTATION_NAME);
            INTERNAL_ACCESSOR_FACTORY_VALUE_METHOD = PrivilegedAccessHelper.getDeclaredMethod(INTERNAL_ACCESSOR_FACTORY_ANNOTATION_CLASS, (String)"value", (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            INTERNAL_XML_LOCATION_ANNOTATION_CLASS = PrivilegedAccessHelper.getClassForName((String)INTERNAL_XML_LOCATION_ANNOTATION_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

