/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;

public class XMLBindingContextFactory
implements jakarta.xml.bind.JAXBContextFactory {
    public JAXBContext createContext(Class<?>[] types, Map<String, ?> map) throws JAXBException {
        Map<String, Object> opts = map != null ? map : Collections.emptyMap();
        String factory = opts.getOrDefault("eclipselink.moxy.factory", "default");
        if (factory instanceof String) {
            switch (factory) {
                case "default": {
                    return JAXBContextFactory.createContext(types, opts);
                }
                case "dynamic": {
                    return DynamicJAXBContextFactory.createContext(types, opts);
                }
            }
            throw new JAXBException(ExceptionLocalization.buildMessage((String)"jaxb_context_factory_property_invalid", (Object[])new Object[]{factory}));
        }
        throw new JAXBException(ExceptionLocalization.buildMessage((String)"jaxb_context_factory_property_invalid", (Object[])new Object[]{factory}));
    }

    public JAXBContext createContext(String string, ClassLoader cl, Map<String, ?> map) throws JAXBException {
        Map<String, Object> opts = map != null ? map : Collections.emptyMap();
        String factory = opts.getOrDefault("eclipselink.moxy.factory", "default");
        if (factory instanceof String) {
            switch (factory) {
                case "default": {
                    return JAXBContextFactory.createContext(string, cl, opts);
                }
                case "dynamic": {
                    return DynamicJAXBContextFactory.createContext(string, cl, opts);
                }
            }
            throw new JAXBException(ExceptionLocalization.buildMessage((String)"jaxb_context_factory_property_invalid", (Object[])new Object[]{factory}));
        }
        throw new JAXBException(ExceptionLocalization.buildMessage((String)"jaxb_context_factory_property_invalid", (Object[])new Object[]{factory}));
    }
}

