/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.util.SizeOf;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.StringValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;
import org.codehaus.jackson.util.CharTypes;

@Persistent(version=1)
public class StringValueImpl
extends FieldValueImpl
implements StringValue {
    private static final long serialVersionUID = 1L;
    protected String value;
    private static final char MIN_VALUE_CHAR = '\u0001';

    StringValueImpl(String value) {
        this.value = value;
    }

    private StringValueImpl() {
        this.value = null;
    }

    @Override
    public StringValueImpl clone() {
        return new StringValueImpl(this.value);
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + SizeOf.stringSize(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof StringValueImpl) {
            return this.value.equals(((StringValueImpl)other).get());
        }
        return false;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof StringValueImpl) {
            return this.value.compareTo(((StringValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an StringValue");
    }

    public String toString() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.STRING;
    }

    @Override
    public StringDefImpl getDefinition() {
        return FieldDefImpl.stringDef;
    }

    @Override
    public StringValue asString() {
        return this;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public void setString(String v) {
        this.value = v;
    }

    @Override
    public String castAsString() {
        return this.value;
    }

    @Override
    FieldValueImpl getNextValue() {
        return new StringValueImpl(StringValueImpl.incrementString(this.value));
    }

    @Override
    FieldValueImpl getMinimumValue() {
        return new StringValueImpl("");
    }

    @Override
    public String formatForKey(FieldDef field, int storageSize) {
        return StringValueImpl.toKeyString(this.value);
    }

    @Override
    public JsonNode toJsonNode() {
        return new TextNode(this.value);
    }

    @Override
    public void toStringBuilder(StringBuilder sb) {
        if (this.value == null) {
            sb.append("null");
            return;
        }
        sb.append('\"');
        CharTypes.appendQuoted(sb, this.value);
        sb.append('\"');
    }

    public static StringValueImpl create(String value) {
        return new StringValueImpl(value);
    }

    public static String incrementString(String value) {
        return value + '\u0001';
    }

    static String toKeyString(String value) {
        return value;
    }
}

