/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.util.Collection;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class CollectionReadObjectTest
extends ReadObjectTest {
    Class<?> collectionClass;

    public CollectionReadObjectTest() {
    }

    public CollectionReadObjectTest(Object originalObject) {
        super(originalObject);
        this.setDescription("The test reads the intended object from the database and checks if it was read properly");
        this.setName("CollectionReadObjectTest(" + ((Restaurant)originalObject).getName() + ")");
    }

    protected void verify() {
        super.verify();
        this.getSession().logMessage("original Restaurant: " + this.getOriginalObject());
        this.getSession().logMessage("from db  Restaurant: " + this.objectFromDatabase);
        Collection waiters = ((Restaurant)this.objectFromDatabase).getWaiters();
        CollectionMapping waiterMapping = (CollectionMapping)this.getSession().getDescriptor(Restaurant.class).getMappingForAttributeName("waiters");
        if (!waiters.getClass().equals(waiterMapping.getContainerPolicy().getContainerClass())) {
            throw new TestErrorException("The waiters collection is not of the correct type.");
        }
        int origSize = ((Restaurant)this.getOriginalObject()).getWaiters().size();
        if (origSize != waiters.size()) {
            throw new TestErrorException("The waiters read from the database does not match the size of the original. (" + origSize + " != " + waiters.size() + ").");
        }
    }
}

