/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.transparentindirection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;

public class Order
extends AbstractOrder {
    public Collection salesReps;
    public Collection contacts;
    public Collection lines;

    public Order() {
    }

    public Order(String customerName) {
        super(customerName);
    }

    @Override
    public void addContact(String contact) {
        this.contacts.add(contact);
    }

    @Override
    public void addLine(AbstractOrderLine line) {
        this.lines.add(line);
        line.order = this;
    }

    @Override
    public void addSalesRep(AbstractSalesRep salesRep) {
        this.salesReps.add(salesRep);
        salesRep.addOrder(this);
    }

    @Override
    public boolean containsContact(String contactName) {
        return this.contacts.contains(contactName);
    }

    @Override
    public boolean containsLine(AbstractOrderLine line) {
        return this.lines.contains(line);
    }

    @Override
    public boolean containsSalesRep(AbstractSalesRep salesRep) {
        return this.salesReps.contains(salesRep);
    }

    @Override
    public Object getContactContainer() {
        return this.contacts;
    }

    @Override
    public Enumeration getContactStream() {
        return new Vector(this.contacts).elements();
    }

    @Override
    public Object getLineContainer() {
        return this.lines;
    }

    @Override
    public void clearLines() {
        this.lines = new Vector();
    }

    @Override
    public Enumeration getLineStream() {
        return new Vector(this.lines).elements();
    }

    @Override
    public int getNumberOfContacts() {
        return this.contacts.size();
    }

    @Override
    public int getNumberOfLines() {
        return this.lines.size();
    }

    @Override
    public int getNumberOfSalesReps() {
        return this.salesReps.size();
    }

    @Override
    public Object getSalesRepContainer() {
        return this.salesReps;
    }

    @Override
    public Enumeration getSalesRepStream() {
        return new Vector(this.salesReps).elements();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.salesReps = new Vector();
        this.contacts = new Vector();
        this.lines = new Vector();
    }

    @Override
    public void removeContact(String contact) {
        this.contacts.remove(contact);
    }

    @Override
    public void removeLine(AbstractOrderLine line) {
        this.lines.remove(line);
    }

    @Override
    public void removeSalesRep(AbstractSalesRep salesRep) {
        this.salesReps.remove(salesRep);
        salesRep.removeOrder(this);
    }
}

