/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TestWrapper;

public class TestVariation {
    protected static char separator = (char)32;

    public static Vector<TestCase> get(Object object, String str, TestCase test) {
        Vector<TestCase> testsIn = new Vector<TestCase>(1);
        testsIn.add(test);
        return TestVariation.get(object, str, testsIn);
    }

    public static Vector<TestCase> get(Object object, String str, Vector<TestCase> testsIn) {
        Vector<String> names = TestVariation.getNames(str);
        Vector<TestCase> testsOut = new Vector<TestCase>();
        if (names.isEmpty() || testsIn.isEmpty()) {
            return testsOut;
        }
        Vector<Method> getters = new Vector<Method>();
        Vector<Method> setters = new Vector<Method>();
        Vector<Field> fields = new Vector<Field>();
        TestVariation.getMembers(object.getClass(), names, getters, setters, fields, true);
        int numberOfTests = (int)Math.pow(2.0, names.size());
        for (int i = 0; i < numberOfTests; ++i) {
            Enumeration<TestCase> enumtr = testsIn.elements();
            while (enumtr.hasMoreElements()) {
                InnerTestWrapper testWrapper = TestVariation.createTest(i, object, names, getters, setters, fields, enumtr.nextElement());
                testsOut.addElement(testWrapper);
            }
        }
        return testsOut;
    }

    protected static Vector<String> getNames(String str) {
        Vector<String> names = new Vector<String>();
        String[] strPair = TestVariation.splitString(str);
        while (strPair[0] != null) {
            names.addElement(strPair[0]);
            strPair = TestVariation.splitString(strPair[1]);
        }
        return names;
    }

    protected static InnerTestWrapper createTest(int index, Object object, Vector<String> names, Vector<Method> getters, Vector<Method> setters, Vector<Field> fields, TestCase test) {
        boolean[] values = new boolean[names.size()];
        int i = 0;
        while (index > 0) {
            values[i] = index % 2 == 1;
            ++i;
            index /= 2;
        }
        String[] namesArray = new String[names.size()];
        namesArray = names.toArray(namesArray);
        Method[] gettersArray = new Method[names.size()];
        gettersArray = getters.toArray(gettersArray);
        Method[] settersArray = new Method[names.size()];
        settersArray = setters.toArray(settersArray);
        Field[] fieldsArray = new Field[names.size()];
        fieldsArray = fields.toArray(fieldsArray);
        return new InnerTestWrapper(test, object, values, namesArray, gettersArray, settersArray, fieldsArray);
    }

    protected static String[] splitString(String str) {
        String[] out = new String[]{null, null};
        if (str == null) {
            return out;
        }
        int first = -1;
        int lastPlusOne = str.length();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (first == -1) {
                if (ch == separator) continue;
                first = i;
                continue;
            }
            if (ch != separator) continue;
            lastPlusOne = i;
            break;
        }
        if (first == -1) {
            return out;
        }
        out[0] = str.substring(first, lastPlusOne);
        out[1] = str.substring(lastPlusOne, str.length());
        return out;
    }

    protected static void getMembers(Class<?> cls, Vector<String> names, Vector<Method> getters, Vector<Method> setters, Vector<Field> fields, boolean throwExceptionIfNotFound) {
        int i;
        Method[] allMethods = cls.getMethods();
        Field[] allFields = cls.getFields();
        Vector<Method> candidateGetters = new Vector<Method>();
        Vector<Method> candidateSetters = new Vector<Method>();
        Vector<Field> candidateFields = new Vector<Field>();
        Vector<String> candidateGettersNames = new Vector<String>();
        Vector<String> candidateSettersNames = new Vector<String>();
        Vector<String> candidateFieldsNames = new Vector<String>();
        for (i = 0; i < allMethods.length; ++i) {
            Class<?> returnType = allMethods[i].getReturnType();
            Class<?>[] parameterTypes = allMethods[i].getParameterTypes();
            if (returnType.equals(Boolean.TYPE) && parameterTypes.length == 0) {
                candidateGetters.addElement(allMethods[i]);
                candidateGettersNames.addElement(allMethods[i].getName().toLowerCase());
                continue;
            }
            if (!returnType.equals(Void.TYPE) || parameterTypes.length != 1 || !parameterTypes[0].equals(Boolean.TYPE)) continue;
            candidateSetters.addElement(allMethods[i]);
            candidateSettersNames.addElement(allMethods[i].getName().toLowerCase());
        }
        for (i = 0; i < allFields.length; ++i) {
            Class<?> type = allFields[i].getType();
            if (!type.equals(Boolean.TYPE)) continue;
            candidateFields.addElement(allFields[i]);
            candidateFieldsNames.addElement(allFields[i].getName().toLowerCase());
        }
        for (i = 0; i < names.size(); ++i) {
            int j;
            Method getter = null;
            Method setter = null;
            Field field = null;
            String name = names.elementAt(i).toLowerCase();
            for (j = 0; j < candidateGetters.size(); ++j) {
                if (!((String)candidateGettersNames.elementAt(j)).contains(name)) continue;
                getter = (Method)candidateGetters.elementAt(j);
                candidateGetters.remove(j);
                candidateGettersNames.remove(j);
                break;
            }
            for (j = 0; j < candidateSetters.size(); ++j) {
                if (!((String)candidateSettersNames.elementAt(j)).contains(name)) continue;
                setter = (Method)candidateSetters.elementAt(j);
                candidateSetters.remove(j);
                candidateSettersNames.remove(j);
                break;
            }
            for (j = 0; j < candidateFields.size(); ++j) {
                if (!((String)candidateFieldsNames.elementAt(j)).contains(name)) continue;
                field = (Field)candidateFields.elementAt(j);
                candidateFields.remove(j);
                candidateFieldsNames.remove(j);
                break;
            }
            if (field != null || setter != null && getter != null) {
                setters.add(setter);
                getters.add(getter);
                fields.add(field);
                continue;
            }
            if (throwExceptionIfNotFound) {
                throw new TestWarningException("Can't find a setter/getter or field for " + names.elementAt(i));
            }
            names.remove(i);
            --i;
        }
    }

    protected static class InnerTestWrapper
    extends TestWrapper {
        protected Object object;
        private Field[] fields;
        private Method[] getters;
        private Method[] setters;
        private boolean[] required;
        private boolean[] original;

        public InnerTestWrapper(TestCase test, Object object, boolean[] values, String[] names, Method[] getters, Method[] setters, Field[] fields) {
            super(test);
            this.object = object;
            this.original = new boolean[values.length];
            this.required = new boolean[values.length];
            this.getters = getters;
            this.setters = setters;
            this.fields = fields;
            System.arraycopy(values, 0, this.required, 0, values.length);
            for (int i = 0; i < values.length; ++i) {
                String name = fields[i] != null ? fields[i].getName() : names[i];
                this.setName(this.getName() + " " + name + "=" + values[i]);
            }
        }

        @Override
        protected void setup() throws Throwable {
            for (int i = 0; i < this.required.length; ++i) {
                Object[] args;
                if (this.getters[i] != null) {
                    args = new Object[]{};
                    Boolean res = (Boolean)this.getters[i].invoke(this.object, args);
                    this.original[i] = res;
                } else {
                    this.original[i] = this.fields[i].getBoolean(this.object);
                }
                if (this.setters[i] != null) {
                    args = new Object[]{this.required[i]};
                    this.setters[i].invoke(this.object, args);
                    continue;
                }
                this.fields[i].setBoolean(this.object, this.required[i]);
            }
            super.setup();
        }

        @Override
        public void reset() throws Throwable {
            super.reset();
            for (int i = this.required.length - 1; i >= 0; --i) {
                if (this.setters[i] != null) {
                    Object[] args = new Object[]{this.original[i]};
                    this.setters[i].invoke(this.object, args);
                    continue;
                }
                this.fields[i].setBoolean(this.object, this.original[i]);
            }
        }
    }
}

