/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.CompOpIter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class AnyOpIter
extends PlanIter {
    private static final int theChunkSize = 10;
    private final FunctionLib.FuncCode theAnyCode;
    private final FunctionLib.FuncCode theCompCode;
    private final PlanIter theLeftOp;
    private final PlanIter theRightOp;

    public AnyOpIter(Expr e, int resultReg, FunctionLib.FuncCode code, PlanIter[] argIters) {
        super(e, resultReg);
        this.theAnyCode = code;
        this.theCompCode = FuncAnyOp.anyToComp(code);
        assert (argIters.length == 2);
        this.theLeftOp = argIters[0];
        this.theRightOp = argIters[1];
    }

    AnyOpIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = AnyOpIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theAnyCode = FunctionLib.FuncCode.values()[ordinal];
        this.theCompCode = FuncAnyOp.anyToComp(this.theAnyCode);
        this.theLeftOp = AnyOpIter.deserializeIter(in, serialVersion);
        this.theRightOp = AnyOpIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theAnyCode.ordinal());
        AnyOpIter.serializeIter(this.theLeftOp, out, serialVersion);
        AnyOpIter.serializeIter(this.theRightOp, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ANY_OP;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theAnyCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AnyOpIterState());
        this.theLeftOp.open(rcb);
        this.theRightOp.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FieldValueImpl rv1;
        AnyOpIterState state = (AnyOpIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theLeftOp.next(rcb);
        if (!more) {
            this.done(rcb, state, false);
            return true;
        }
        more = this.theRightOp.next(rcb);
        if (!more) {
            this.done(rcb, state, false);
            return true;
        }
        FieldValueImpl lv1 = rcb.getRegVal(this.theLeftOp.getResultReg());
        if (this.compare(rcb, state, lv1, rv1 = rcb.getRegVal(this.theRightOp.getResultReg()))) {
            this.done(rcb, state, true);
            return true;
        }
        if (lv1.isTuple()) {
            lv1 = ((TupleValue)lv1).toRecord();
        }
        if (!(more = this.theLeftOp.next(rcb))) {
            while (this.theRightOp.next(rcb)) {
                FieldValueImpl rv2 = rcb.getRegVal(this.theRightOp.getResultReg());
                if (!this.compare(rcb, state, lv1, rv2)) continue;
                this.done(rcb, state, true);
                return true;
            }
            this.done(rcb, state, false);
            return true;
        }
        FieldValueImpl lv2 = rcb.getRegVal(this.theLeftOp.getResultReg());
        if (rv1.isTuple()) {
            rv1 = ((TupleValue)rv1).toRecord();
        }
        if (!(more = this.theRightOp.next(rcb))) {
            if (this.compare(rcb, state, lv2, rv1)) {
                this.done(rcb, state, true);
                return true;
            }
            while (this.theLeftOp.next(rcb)) {
                lv2 = rcb.getRegVal(this.theLeftOp.getResultReg());
                if (!this.compare(rcb, state, lv2, rv1)) continue;
                this.done(rcb, state, true);
                return true;
            }
            this.done(rcb, state, false);
            return true;
        }
        FieldValueImpl rv2 = rcb.getRegVal(this.theRightOp.getResultReg());
        if (this.compare(rcb, state, lv1, rv2) || this.compare(rcb, state, lv2, rv1) || this.compare(rcb, state, lv2, rv2)) {
            this.done(rcb, state, true);
            return true;
        }
        ArrayList<FieldValueImpl> lchunk = new ArrayList<FieldValueImpl>(10);
        while (true) {
            if (lchunk.size() < 10 && this.theLeftOp.next(rcb)) {
                lv1 = rcb.getRegVal(this.theLeftOp.getResultReg());
                lchunk.add(lv1);
                continue;
            }
            while (this.theRightOp.next(rcb)) {
                rv1 = rcb.getRegVal(this.theRightOp.getResultReg());
                for (int i = 0; i < lchunk.size(); ++i) {
                    lv1 = (FieldValueImpl)lchunk.get(i);
                    if (!this.compare(rcb, state, lv1, rv1)) continue;
                    this.done(rcb, state, true);
                    return true;
                }
            }
            if (lchunk.size() != 10) break;
            this.theRightOp.reset(rcb);
            lchunk.clear();
        }
        this.done(rcb, state, false);
        return true;
    }

    private void done(RuntimeControlBlock rcb, AnyOpIterState state, boolean result) {
        FieldValueImpl res = state.theHaveNull && !result ? NullValueImpl.getInstance() : FieldDefImpl.booleanDef.createBoolean(result);
        rcb.setRegVal(this.theResultReg, res);
        state.done();
    }

    private boolean compare(RuntimeControlBlock rcb, AnyOpIterState state, FieldValueImpl v0, FieldValueImpl v1) {
        state.theResult.clear();
        CompOpIter.compare(rcb, v0, v1, this.theCompCode, state.theResult, this.getLocation());
        if (state.theResult.haveNull) {
            state.theHaveNull = true;
            return false;
        }
        if (state.theResult.incompatible) {
            return false;
        }
        int comp = state.theResult.comp;
        switch (this.theCompCode) {
            case OP_EQ: {
                return comp == 0;
            }
            case OP_NEQ: {
                return comp != 0;
            }
            case OP_GT: {
                return comp > 0;
            }
            case OP_GE: {
                return comp >= 0;
            }
            case OP_LT: {
                return comp < 0;
            }
            case OP_LE: {
                return comp <= 0;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theLeftOp.reset(rcb);
        this.theRightOp.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        this.theLeftOp.close(rcb);
        this.theRightOp.close(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theLeftOp.display(sb, formatter);
        sb.append(",\n");
        this.theRightOp.display(sb, formatter);
    }

    private static class AnyOpIterState
    extends PlanIterState {
        final CompOpIter.CompResult theResult = new CompOpIter.CompResult();
        boolean theHaveNull;

        private AnyOpIterState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theResult.clear();
            this.theHaveNull = false;
        }
    }
}

