/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprConst;
import oracle.kv.impl.query.compiler.ExprPromote;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprArraySlice
extends Expr {
    private Expr theInput;
    private Expr theLowExpr;
    private Expr theHighExpr;
    private Long theLowValue;
    private Long theHighValue;
    private ExprVar theCtxItemVar;
    private boolean theIsUnarySlice;

    ExprArraySlice(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input) {
        super(qcb, sctx, Expr.ExprKind.ARRAY_SLICE, location);
        this.theInput = input;
        this.theInput.addParent(this);
    }

    ExprArraySlice(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, Expr input, Long pos) {
        super(qcb, sctx, Expr.ExprKind.ARRAY_SLICE, location);
        this.theInput = input;
        this.theInput.addParent(this);
        if (pos.intValue() < 0) {
            this.theLowValue = 0L;
            this.theHighValue = pos;
        } else {
            this.theLowValue = pos;
            this.theHighValue = pos;
        }
        this.theIsUnarySlice = true;
    }

    void addCtxVars(ExprVar ctxItemVar) {
        this.theCtxItemVar = ctxItemVar;
    }

    void addBoundaryExprs(Expr lowExpr, Expr highExpr) {
        this.theLowExpr = lowExpr;
        this.theHighExpr = highExpr;
        if (this.theLowExpr != null) {
            this.theLowExpr.addParent(this);
        }
        if (this.theHighExpr != null) {
            this.theHighExpr.addParent(this);
        }
        if (this.theLowExpr == null && this.theHighExpr == null) {
            this.theCtxItemVar = null;
        }
        this.checkConst();
        if (!this.isConst()) {
            if (this.theLowExpr != null) {
                this.theLowExpr = ExprPromote.create(this, this.theLowExpr, TypeManager.LONG_QSTN());
            }
            if (this.theHighExpr != null) {
                this.theHighExpr = ExprPromote.create(this, this.theHighExpr, TypeManager.LONG_QSTN());
            }
        }
    }

    @Override
    int getNumChildren() {
        if (this.theLowExpr == null && this.theHighExpr == null) {
            return 1;
        }
        if (this.theLowExpr == null || this.theHighExpr == null) {
            return 2;
        }
        return 3;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    void setInput(Expr newExpr, boolean destroy) {
        this.theInput.removeParent(this, destroy);
        this.theInput = newExpr;
        newExpr.addParent(this);
    }

    Expr getLowExpr() {
        return this.theLowExpr;
    }

    void setLowExpr(Expr newExpr, boolean destroy) {
        this.theLowExpr.removeParent(this, destroy);
        this.theLowExpr = newExpr;
        newExpr.addParent(this);
    }

    void removeLowExpr(boolean destroy) {
        this.theLowExpr.removeParent(this, destroy);
        this.theLowExpr = null;
    }

    Expr getHighExpr() {
        return this.theHighExpr;
    }

    void setHighExpr(Expr newExpr, boolean destroy) {
        this.theHighExpr.removeParent(this, destroy);
        this.theHighExpr = newExpr;
        newExpr.addParent(this);
    }

    void removeHighExpr(boolean destroy) {
        this.theHighExpr.removeParent(this, destroy);
        this.theHighExpr = null;
    }

    Long getLowValue() {
        return this.theLowValue;
    }

    Long getHighValue() {
        return this.theHighValue;
    }

    ExprVar getCtxItemVar() {
        return this.theCtxItemVar;
    }

    boolean hasBounds() {
        return this.theLowExpr != null || this.theHighExpr != null || this.theLowValue != null || this.theHighValue != null;
    }

    boolean isConst() {
        return this.theLowExpr == null && this.theHighExpr == null;
    }

    void checkConst() {
        if (this.isConst() && this.theLowValue != null && this.theLowValue != null) {
            assert (this.theCtxItemVar == null);
            return;
        }
        if (this.theLowValue == null) {
            if (this.theLowExpr == null) {
                this.theLowValue = 0L;
            } else if (this.theLowExpr.getKind() == Expr.ExprKind.CONST) {
                this.theLowValue = this.handleConstExpr(this.theLowExpr);
                if (this.theLowValue < 0L) {
                    this.theLowValue = 0L;
                }
                this.theLowExpr.removeParent(this, true);
                this.theLowExpr = null;
            }
        }
        if (this.theHighValue == null) {
            if (this.theHighExpr == null) {
                this.theHighValue = Integer.MAX_VALUE;
            } else if (this.theHighExpr.getKind() == Expr.ExprKind.CONST) {
                this.theHighValue = this.handleConstExpr(this.theHighExpr);
                this.theHighExpr.removeParent(this, true);
                this.theHighExpr = null;
            }
        }
        if (this.theLowValue != null && this.theHighValue != null && this.theLowValue.longValue() == this.theHighValue.longValue()) {
            this.theIsUnarySlice = true;
        }
        if (this.theCtxItemVar != null && !this.theCtxItemVar.hasParents()) {
            this.theCtxItemVar = null;
        }
    }

    private Long handleConstExpr(Expr expr) {
        ExprType.TypeCode c = expr.getType().getCode();
        FieldValueImpl value = ((ExprConst)expr).getValue();
        if (c == ExprType.TypeCode.INT || c == ExprType.TypeCode.LONG) {
            return value.getLong();
        }
        throw new QueryException("Boundary const in slice step has invalid type.\nExpected long or integer type. Actual type is: \n" + expr.getType(), expr.getLocation());
    }

    @Override
    ExprType computeType() {
        boolean isNotArray;
        ExprType inType = this.theInput.getType();
        this.checkConst();
        boolean bl = isNotArray = inType.isAtomic() || inType.isRecord() || inType.isMap();
        if (this.theQCB.strictMode() && isNotArray) {
            throw new QueryException("Wrong input type for [] operator. Expected an array type. Actual type is :\n" + inType.getDef().getDDLString(), this.theLocation);
        }
        if (this.isConst()) {
            if (this.theLowValue.compareTo(this.theHighValue) > 0) {
                return TypeManager.EMPTY();
            }
            if (this.theHighValue.compareTo(0L) < 0) {
                return TypeManager.EMPTY();
            }
            if (isNotArray && this.theLowValue.compareTo(0L) > 0) {
                return TypeManager.EMPTY();
            }
        }
        ExprType.Quantifier inQuant = inType.getQuantifier();
        ExprType.Quantifier outQuant = ExprType.Quantifier.STAR;
        if (this.theIsUnarySlice || isNotArray) {
            outQuant = TypeManager.getUnionQuant(inQuant, ExprType.Quantifier.QSTN);
        }
        return inType.getArrayElementType(outQuant);
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL() || this.getType().isAny() || this.getType().isAnyJson();
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
        if (this.isConst()) {
            sb.append("[");
            if (this.theLowValue != null || this.theHighValue != null) {
                if (this.theLowValue == this.theHighValue) {
                    sb.append(".").append(this.theLowValue).append(".");
                } else {
                    if (this.theLowValue != null) {
                        sb.append(this.theLowValue);
                    }
                    sb.append("..");
                    if (this.theHighValue != null) {
                        sb.append(this.theHighValue);
                    }
                }
            }
            sb.append("]");
        } else {
            sb.append(".\n");
            formatter.indent(sb);
            sb.append("[\n");
            if (this.theLowExpr != null) {
                this.theLowExpr.display(sb, formatter);
                sb.append("\n");
            }
            formatter.indent(sb);
            sb.append("..\n");
            if (this.theHighExpr != null) {
                this.theHighExpr.display(sb, formatter);
            }
            sb.append("]");
        }
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
    }
}

