/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.IOException;
import java.util.logging.Logger;
import oracle.kv.impl.async.AsyncVersionedRemote;
import oracle.kv.impl.async.AsyncVersionedRemoteDialogInitiator;
import oracle.kv.impl.async.CreatorEndpoint;
import oracle.kv.impl.async.DialogType;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.ResultHandler;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public abstract class AsyncVersionedRemoteInitiator
implements AsyncVersionedRemote {
    protected final CreatorEndpoint endpoint;
    protected final DialogType dialogType;
    protected final Logger logger;

    protected AsyncVersionedRemoteInitiator(CreatorEndpoint endpoint, DialogType dialogType, Logger logger) {
        this.endpoint = ObjectUtil.checkNull("endpoint", endpoint);
        this.dialogType = ObjectUtil.checkNull("dialogType", dialogType);
        this.logger = ObjectUtil.checkNull("logger", logger);
    }

    protected MessageOutput startRequest(AsyncVersionedRemote.MethodOp methodOp, short serialVersion) {
        MessageOutput request = new MessageOutput();
        try {
            SerializationUtil.writePackedInt(request, methodOp.getValue());
            request.writeShort(serialVersion);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return request;
    }

    protected void getSerialVersion(short serialVersion, AsyncVersionedRemote.MethodOp methodOp, long timeoutMillis, final ResultHandler<Short> handler) {
        MessageOutput request = this.startRequest(methodOp, serialVersion);
        try {
            SerializationUtil.writePackedLong(request, timeoutMillis);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.startDialog(new AsyncVersionedRemoteDialogInitiator<Short>(request, this.logger, handler){

            @Override
            public Short readResult(MessageInput in, short responderSerialVersion) throws IOException {
                return in.readShort();
            }

            public String toString() {
                return handler.toString();
            }
        }, timeoutMillis);
    }

    protected void startDialog(AsyncVersionedRemoteDialogInitiator<?> handler, long timeoutMillis) {
        this.endpoint.startDialog(this.dialogType.getDialogTypeId(), handler, timeoutMillis);
    }
}

