/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class ReportItem
implements Cloneable,
Serializable {
    protected Expression attributeExpression;
    protected String name;
    protected DatabaseMapping mapping;
    protected ClassDescriptor descriptor;
    protected Class<?> resultType;
    protected JoinedAttributeManager joinedAttributeManager;
    protected int resultIndex;

    public ReportItem() {
    }

    public ReportItem(String name, Expression attributeExpression) {
        this();
        this.name = name;
        this.attributeExpression = attributeExpression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Expression getAttributeExpression() {
        return this.attributeExpression;
    }

    public void setAttributeExpression(Expression attributeExpression) {
        this.attributeExpression = attributeExpression;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        if (this.joinedAttributeManager == null) {
            this.joinedAttributeManager = new JoinedAttributeManager();
        }
        return this.joinedAttributeManager;
    }

    public JoinedAttributeManager getJoinedAttributeManagerInternal() {
        return this.joinedAttributeManager;
    }

    public boolean hasJoining() {
        return this.joinedAttributeManager != null;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void initialize(ReportQuery query) throws QueryException {
        if (this.mapping == null && this.attributeExpression != null) {
            DatabaseMapping mapping = this.attributeExpression.getLeafMapping(query, query.getDescriptor(), query.getSession());
            if (mapping == null) {
                if (this.attributeExpression.isExpressionBuilder()) {
                    Class<?> resultClass = ((ExpressionBuilder)this.attributeExpression).getQueryClass();
                    if (resultClass == null) {
                        resultClass = query.getReferenceClass();
                        ((ExpressionBuilder)this.attributeExpression).setQueryClass(resultClass);
                    }
                    this.setDescriptor((ClassDescriptor)query.getSession().getDescriptor((Class)resultClass));
                    if (this.getDescriptor().hasInheritance()) {
                        ((ExpressionBuilder)this.attributeExpression).setShouldUseOuterJoinForMultitableInheritance(true);
                    }
                }
            } else if (mapping.isAbstractDirectMapping() || this.attributeExpression.isMapEntryExpression() || mapping.isAggregateObjectMapping() || mapping.isDirectCollectionMapping()) {
                this.setMapping(mapping);
            } else if (mapping.isForeignReferenceMapping()) {
                if (mapping.getReferenceDescriptor() != null) {
                    this.setDescriptor(mapping.getReferenceDescriptor());
                    if (this.getDescriptor().hasInheritance()) {
                        ((QueryKeyExpression)this.attributeExpression).setShouldUseOuterJoinForMultitableInheritance(true);
                    }
                }
            } else {
                throw QueryException.invalidExpressionForQueryItem(this.attributeExpression, query);
            }
            if (this.hasJoining()) {
                this.joinedAttributeManager.setDescriptor(this.descriptor);
                this.joinedAttributeManager.setBaseQuery(query);
            }
            if (this.getAttributeExpression() != null) {
                if (this.getAttributeExpression().getBuilder().wasQueryClassSetInternally()) {
                    this.attributeExpression = this.attributeExpression.rebuildOn(query.getExpressionBuilder());
                }
                if (this.hasJoining()) {
                    this.joinedAttributeManager.setBaseExpressionBuilder(this.attributeExpression.getBuilder());
                }
            } else if (this.hasJoining()) {
                this.joinedAttributeManager.setBaseExpressionBuilder(query.getExpressionBuilder());
            }
            if (this.hasJoining()) {
                this.joinedAttributeManager.prepareJoinExpressions(query.getSession());
                this.joinedAttributeManager.processJoinedMappings(query.getSession());
                this.joinedAttributeManager.computeJoiningMappingQueries(query.getSession());
            }
        }
    }

    public boolean isConstructorItem() {
        return false;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setJoinedAttributeManager(JoinedAttributeManager joinManager) {
        this.joinedAttributeManager = joinManager;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setResultIndex(int resultIndex) {
        this.resultIndex = resultIndex;
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().setParentResultIndex(resultIndex);
        }
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
        if (this.getAttributeExpression() != null && this.getAttributeExpression().isFunctionExpression()) {
            ((FunctionExpression)this.getAttributeExpression()).setResultType(resultType);
        }
    }

    public String toString() {
        return "ReportQueryItem(" + this.getName() + " -> " + this.getAttributeExpression() + ")";
    }
}

