/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.rs;

import jakarta.activation.DataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.exceptions.JSONException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.oxm.JSONWithPadding;

@Produces(value={"application/json", "*/*", "application/x-javascript"})
@Consumes(value={"application/json", "*/*"})
@Provider
public class MOXyJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final String APPLICATION_XJAVASCRIPT = "application/x-javascript";
    private static final String CHARSET = "charset";
    private static final QName EMPTY_STRING_QNAME = new QName("");
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    @Context
    protected Providers providers;
    private String attributePrefix = null;
    private Map<Set<Class<?>>, jakarta.xml.bind.JAXBContext> contextCache = new HashMap();
    private boolean formattedOutput = false;
    private boolean includeRoot = false;
    private boolean marshalEmptyCollections = true;
    private Map<String, String> namespacePrefixMapper;
    private char namespaceSeperator = (char)46;
    private String valueWrapper;
    private boolean wrapperAsArrayName = false;

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    protected Set<Class<?>> getDomainClasses(Type genericType) {
        if (null == genericType) {
            return this.asSet(Object.class);
        }
        if (genericType instanceof Class && genericType != JAXBElement.class) {
            Class clazz = (Class)genericType;
            if (clazz.isArray()) {
                return this.getDomainClasses(clazz.getComponentType());
            }
            return this.asSet(clazz);
        }
        if (genericType instanceof ParameterizedType) {
            LinkedHashSet result = new LinkedHashSet();
            result.add((Class)((ParameterizedType)genericType).getRawType());
            Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
            if (types.length > 0) {
                for (Type upperType : types) {
                    result.addAll(this.getDomainClasses(upperType));
                }
            }
            return result;
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            return this.getDomainClasses(genericArrayType.getGenericComponentType());
        }
        if (genericType instanceof WildcardType) {
            LinkedHashSet result = new LinkedHashSet();
            Type[] upperTypes = ((WildcardType)genericType).getUpperBounds();
            if (upperTypes.length > 0) {
                for (Type upperType : upperTypes) {
                    result.addAll(this.getDomainClasses(upperType));
                }
            } else {
                result.add(Object.class);
            }
            return result;
        }
        return this.asSet(Object.class);
    }

    private Set<Class<?>> asSet(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        result.add(clazz);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected jakarta.xml.bind.JAXBContext getJAXBContext(Set<Class<?>> domainClasses, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, ?> httpHeaders) throws JAXBException {
        jakarta.xml.bind.JAXBContext jaxbContext = this.contextCache.get(domainClasses);
        if (null != jaxbContext) {
            return jaxbContext;
        }
        Map<Set<Class<?>>, jakarta.xml.bind.JAXBContext> map = this.contextCache;
        synchronized (map) {
            jaxbContext = this.contextCache.get(domainClasses);
            if (null != jaxbContext) {
                return jaxbContext;
            }
            ContextResolver resolver = null;
            if (null != this.providers) {
                resolver = this.providers.getContextResolver(jakarta.xml.bind.JAXBContext.class, mediaType);
            }
            if (null != resolver && domainClasses.size() == 1) {
                jaxbContext = (jakarta.xml.bind.JAXBContext)resolver.getContext(domainClasses.iterator().next());
            }
            if (null == jaxbContext) {
                jaxbContext = JAXBContextFactory.createContext(domainClasses.toArray(new Class[0]), null);
                this.contextCache.put(domainClasses, jaxbContext);
                return jaxbContext;
            }
            if (jaxbContext instanceof JAXBContext) {
                return jaxbContext;
            }
            jaxbContext = JAXBContextFactory.createContext(domainClasses.toArray(new Class[0]), null);
            this.contextCache.put(domainClasses, jaxbContext);
            return jaxbContext;
        }
    }

    private jakarta.xml.bind.JAXBContext getJAXBContext(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (null == genericType) {
            genericType = type;
        }
        try {
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            return this.getJAXBContext(domainClasses, annotations, mediaType, null);
        }
        catch (JAXBException e) {
            AbstractSessionLog.getLog().logThrowable(6, "moxy", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeperator;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public boolean isMarshalEmptyCollections() {
        return this.marshalEmptyCollections;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (CoreClassConstants.APBYTE == type || CoreClassConstants.STRING == type) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return false;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class == type) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray() && (type.getComponentType().isArray() || type.getComponentType().isPrimitive() || type.getComponentType().getPackage().getName().startsWith("java."))) {
            return false;
        }
        if (JAXBElement.class.isAssignableFrom(type)) {
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            for (Class<?> domainClass : domainClasses) {
                if (!this.isReadable(domainClass, null, annotations, mediaType) && String.class != domainClass) continue;
                return true;
            }
            return false;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            for (Class<?> domainClass : domainClasses) {
                if (!this.isReadable(domainClass, null, annotations, mediaType) && String.class != domainClass) continue;
                return true;
            }
            return false;
        }
        return null != this.getJAXBContext(type, genericType, annotations, mediaType);
    }

    public boolean isWrapperAsArrayName() {
        return this.wrapperAsArrayName;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == JSONWithPadding.class && APPLICATION_XJAVASCRIPT.equals(mediaType.toString())) {
            return true;
        }
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (CoreClassConstants.APBYTE == type || CoreClassConstants.STRING == type || type.isPrimitive()) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class == type) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray() && (String.class.equals(type.getComponentType()) || type.getComponentType().isPrimitive() || Helper.isPrimitiveWrapper(type.getComponentType()))) {
            return true;
        }
        if (type.isArray() && (type.getComponentType().isArray() || type.getComponentType().isPrimitive() || type.getComponentType().getPackage().getName().startsWith("java."))) {
            return false;
        }
        if (JAXBElement.class.isAssignableFrom(type)) {
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            for (Class<?> domainClass : domainClasses) {
                if (!this.isWriteable(domainClass, null, annotations, mediaType) && domainClass != String.class) continue;
                return true;
            }
            return false;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Class[] domainArray;
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            if (domainClasses.size() == 3 && JAXBElement.class.isAssignableFrom((domainArray = domainClasses.toArray(new Class[domainClasses.size()]))[1]) && String.class == domainArray[2]) {
                return true;
            }
            for (Class<?> domainClass : domainClasses) {
                if (String.class.equals(domainClass) || domainClass.isPrimitive() || Helper.isPrimitiveWrapper(domainClass)) {
                    return true;
                }
                String packageName = domainClass.getPackage().getName();
                if (null != packageName && packageName.startsWith("java.") || !this.isWriteable(domainClass, null, annotations, mediaType)) continue;
                return true;
            }
            return false;
        }
        return null != this.getJAXBContext(type, genericType, annotations, mediaType);
    }

    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
    }

    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            StreamSource jsonSource;
            if (null == genericType) {
                genericType = type;
            }
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            jakarta.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClasses, annotations, mediaType, httpHeaders);
            SessionLog logger = AbstractSessionLog.getLog();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "moxy_read_from_moxy_json_provider", new Object[0]);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            unmarshaller.setProperty("eclipselink.json.attribute-prefix", (Object)this.attributePrefix);
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)this.includeRoot);
            unmarshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            unmarshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(this.namespaceSeperator));
            if (null != this.valueWrapper) {
                unmarshaller.setProperty("eclipselink.json.value-wrapper", (Object)this.valueWrapper);
            }
            unmarshaller.setProperty("eclipselink.json.wrapper-as-array-name", (Object)this.wrapperAsArrayName);
            this.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
            Map mediaTypeParameters = null;
            if (null != mediaType) {
                mediaTypeParameters = mediaType.getParameters();
            }
            if (null != mediaTypeParameters && mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = (String)mediaTypeParameters.get(CHARSET);
                InputStreamReader entityReader = new InputStreamReader(entityStream, charSet);
                jsonSource = new StreamSource(entityReader);
            } else {
                jsonSource = new StreamSource(entityStream);
            }
            Class<?> domainClass = this.getDomainClass(domainClasses);
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)jsonSource, domainClass);
            if (type.isAssignableFrom(JAXBElement.class)) {
                return jaxbElement;
            }
            Object value = jaxbElement.getValue();
            if (value instanceof ArrayList) {
                if (type.isArray()) {
                    ArrayList arrayList = (ArrayList)value;
                    int arrayListSize = arrayList.size();
                    boolean wrapItemInJAXBElement = this.wrapItemInJAXBElement(genericType);
                    Object array = wrapItemInJAXBElement ? Array.newInstance(JAXBElement.class, arrayListSize) : Array.newInstance(domainClass, arrayListSize);
                    for (int x = 0; x < arrayListSize; ++x) {
                        Object element = this.handleJAXBElement(arrayList.get(x), domainClass, wrapItemInJAXBElement);
                        Array.set(array, x, element);
                    }
                    return array;
                }
                CollectionContainerPolicy containerPolicy = type.isAssignableFrom(List.class) || type.isAssignableFrom(ArrayList.class) || type.isAssignableFrom(Collection.class) ? new CollectionContainerPolicy(ArrayList.class) : (type.isAssignableFrom(Set.class) ? new CollectionContainerPolicy(HashSet.class) : (type.isAssignableFrom(Deque.class) || type.isAssignableFrom(Queue.class) ? new CollectionContainerPolicy(LinkedList.class) : (type.isAssignableFrom(NavigableSet.class) || type.isAssignableFrom(SortedSet.class) ? new CollectionContainerPolicy(TreeSet.class) : new CollectionContainerPolicy(type))));
                Object container = containerPolicy.containerInstance();
                boolean wrapItemInJAXBElement = this.wrapItemInJAXBElement(genericType);
                for (Object element : (Collection)value) {
                    element = this.handleJAXBElement(element, domainClass, wrapItemInJAXBElement);
                    containerPolicy.addInto(element, container, null);
                }
                return container;
            }
            return value;
        }
        catch (UnmarshalException unmarshalException) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            throw new WebApplicationException((Throwable)unmarshalException, builder.build());
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException((Throwable)jaxbException);
        }
        catch (NullPointerException nullPointerException) {
            throw new WebApplicationException((Throwable)JSONException.errorInvalidDocument((Exception)nullPointerException));
        }
    }

    public Class<?> getDomainClass(Set<Class<?>> domainClasses) {
        if (domainClasses.size() == 1) {
            return domainClasses.iterator().next();
        }
        boolean isStringPresent = false;
        for (Class<?> clazz : domainClasses) {
            if (!(clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.") || clazz.getName().startsWith("jakarta.") || List.class.isAssignableFrom(clazz))) {
                return clazz;
            }
            if (clazz != String.class) continue;
            isStringPresent = true;
        }
        if (isStringPresent) {
            return String.class;
        }
        if (domainClasses.size() >= 2) {
            Iterator<Class<?>> it = domainClasses.iterator();
            it.next();
            return it.next();
        }
        return domainClasses.iterator().next();
    }

    private boolean wrapItemInJAXBElement(Type genericType) {
        if (genericType == JAXBElement.class) {
            return true;
        }
        if (genericType instanceof GenericArrayType) {
            return this.wrapItemInJAXBElement(((GenericArrayType)genericType).getGenericComponentType());
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type actualType = parameterizedType.getActualTypeArguments()[0];
            return this.wrapItemInJAXBElement(parameterizedType.getOwnerType()) || this.wrapItemInJAXBElement(parameterizedType.getRawType()) || this.wrapItemInJAXBElement(actualType);
        }
        return false;
    }

    private Object handleJAXBElement(Object element, Class<?> domainClass, boolean wrapItemInJAXBElement) {
        if (wrapItemInJAXBElement) {
            if (element instanceof JAXBElement) {
                return element;
            }
            return new JAXBElement(EMPTY_STRING_QNAME, domainClass, element);
        }
        return JAXBIntrospector.getValue((Object)element);
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public void setMarshalEmptyCollections(boolean marshalEmptyCollections) {
        this.marshalEmptyCollections = marshalEmptyCollections;
    }

    public void setNamespacePrefixMapper(Map<String, String> namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeperator = namespaceSeparator;
    }

    public void setWrapperAsArrayName(boolean wrapperAsArrayName) {
        this.wrapperAsArrayName = wrapperAsArrayName;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    protected boolean supportsMediaType(MediaType mediaType) {
        if (null == mediaType) {
            return true;
        }
        String subtype = mediaType.getSubtype();
        return subtype.equals(JSON) || subtype.endsWith(PLUS_JSON);
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (null == genericType) {
                genericType = type;
            }
            Set<Class<?>> domainClasses = this.getDomainClasses(genericType);
            jakarta.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClasses, annotations, mediaType, httpHeaders);
            SessionLog logger = AbstractSessionLog.getLog();
            if (logger.shouldLog(3, "moxy")) {
                logger.log(3, "moxy", "moxy_write_to_moxy_json_provider", new Object[0]);
            }
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.attribute-prefix", (Object)this.attributePrefix);
            marshaller.setProperty("eclipselink.json.include-root", (Object)this.includeRoot);
            marshaller.setProperty("eclipselink.json.marshal-empty-collections", (Object)this.marshalEmptyCollections);
            marshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(this.namespaceSeperator));
            if (null != this.valueWrapper) {
                marshaller.setProperty("eclipselink.json.value-wrapper", (Object)this.valueWrapper);
            }
            marshaller.setProperty("eclipselink.json.wrapper-as-array-name", (Object)this.wrapperAsArrayName);
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            Map mediaTypeParameters = null;
            if (null != mediaType) {
                mediaTypeParameters = mediaType.getParameters();
            }
            if (null != mediaTypeParameters && mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = (String)mediaTypeParameters.get(CHARSET);
                marshaller.setProperty("jaxb.encoding", (Object)charSet);
            }
            this.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
            if (domainClasses.size() == 1) {
                Class<?> domainClass = domainClasses.iterator().next();
                if (!List.class.isAssignableFrom(type) && !type.isArray() && domainClass.getPackage().getName().startsWith("java.")) {
                    object = new JAXBElement(new QName((String)marshaller.getProperty("eclipselink.json.value-wrapper")), domainClass, object);
                }
            }
            marshaller.marshal(object, entityStream);
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException((Throwable)jaxbException);
        }
    }
}

