/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.models.employee.domain;

import java.io.*;
import java.sql.Timestamp;

/**
 * <b>Purpose</b>: Larger scale projects within the Employee Demo
 * <p><b>Description</b>: LargeProject is a concrete subclass of Project. It is instantiated for Projects with type = 'L'. The additional
 * information (budget, &amp; milestoneVersion) are mapped from the LPROJECT table.
 * @see Project
 */
public class LargeProject extends Project implements org.eclipse.persistence.testing.models.employee.interfaces.LargeProject {
    // implements ChangeTracker for testing(Inherited from Project)
    public double budget;
    public Timestamp milestoneVersion;

    public LargeProject() {
        this.budget = 0.0;
    }

    @Override
    public double getBudget() {
        return budget;
    }

    @Override
    public Timestamp getMilestoneVersion() {
        return milestoneVersion;
    }

    @Override
    public void setBudget(double budget) {
        propertyChange("budget", this.budget, budget);
        this.budget = budget;
    }

    @Override
    public void setMilestoneVersion(Timestamp milestoneVersion) {
        propertyChange("milestoneVersion", this.milestoneVersion, milestoneVersion);
        this.milestoneVersion = milestoneVersion;
    }

    /**
     * Print the project's data.
     */
    public String toString() {
        StringWriter writer = new StringWriter();

        writer.write("Large Project: ");
        writer.write(getName());
        writer.write(" ");
        writer.write(getDescription());
        writer.write(" " + getBudget());
        writer.write(" ");
        writer.write(String.valueOf(getMilestoneVersion()));
        return writer.toString();
    }
}
