/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.schemaframework;

import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SPGExecuteStoredProcedureTest
extends TestCase {
    boolean shouldBindAllParameters;
    int insertSuccess = 1;
    int updateSuccess = 1;
    int deleteSuccess = 1;
    String parameterNamePrefix;
    boolean shouldUseNamedArguments;
    static final Integer menuID = 99;
    static final Integer restaurantID = 100;
    static final Integer dinerID = 101;
    static final Integer personID = 102;
    static final Integer locationID = 103;
    static final Integer waiterID = 104;
    static final Integer menuItemID = 105;
    static final String menuType = "Lunch";
    static final String menuTypeUpdate = "Dinner";
    static final String dinerFirstName = "Steve";
    static final String dinerFirstNameUpdate = "Stephen";
    static final String dinerLastName = "McDonald";
    static final String dinerClass = "B";
    static final String personFirstName = "Dan";
    static final String personFirstNameUpdate = "Danial";
    static final String personLastName = "Smith";
    static final String personClass = "A";
    static final String locationArea = "Downtown";
    static final String locationAreaUpdate = "Southeastern";
    static final String locationCity = "Ottawa";
    static final String waiterFirstName = "Joel";
    static final String waiterLastName = "Clark";
    static final String waiterSpeciality = "Speaking Spanish";
    static final String waiterSpecialityUpdate = "Speaking Spanish and Italian";
    static final String waiterClass = "A";
    static final String menuItemName = "Roasted beef and potato";
    static final Float menuItemPrice = Float.valueOf(20.99f);
    static final Float menuItemPriceUpdate = Float.valueOf(22.99f);
    static final String restaurantName = "May Flower";
    static final String restaurantNameUpdate = "Great Wall Restaurant";

    public void setup() {
        boolean bl = this.shouldUseNamedArguments = !this.getSession().getDatasourcePlatform().isMySQL();
        if (this.shouldUseNamedArguments) {
            this.parameterNamePrefix = this.getSession().getDatasourcePlatform().isOracle() ? "P_" : "";
        }
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("INS_Menu");
        this.addArgumentValue(call, "ID", menuID);
        this.addArgumentValue(call, "REST_ID", restaurantID);
        this.addArgumentValue(call, "TYPE", menuType);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_Diner");
        this.addArgumentValue(call, "ID", dinerID);
        this.addArgumentValue(call, "F_NAME", dinerFirstName);
        this.addArgumentValue(call, "CLASS", dinerClass);
        this.addArgumentValue(call, "L_NAME", dinerLastName);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_Person");
        this.addArgumentValue(call, "ID", personID);
        this.addArgumentValue(call, "F_NAME", personFirstName);
        this.addArgumentValue(call, "CLASS", "A");
        this.addArgumentValue(call, "L_NAME", personLastName);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_Location");
        this.addArgumentValue(call, "AREA", locationArea);
        this.addArgumentValue(call, "ID", locationID);
        this.addArgumentValue(call, "CITY", locationCity);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_Waiter");
        this.addArgumentValue(call, "ID", waiterID);
        this.addArgumentValue(call, "F_NAME", waiterFirstName);
        this.addArgumentValue(call, "SPECIALT", waiterSpeciality);
        this.addArgumentValue(call, "CLASS", "A");
        this.addArgumentValue(call, "W_RST_ID", restaurantID);
        this.addArgumentValue(call, "L_NAME", waiterLastName);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_MenuItem");
        this.addArgumentValue(call, "ID", menuItemID);
        this.addArgumentValue(call, "MENU_ID", menuID);
        this.addArgumentValue(call, "PRICE", menuItemPrice);
        this.addArgumentValue(call, "NAME", menuItemName);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("INS_Restaurant");
        this.addArgumentValue(call, "ID", restaurantID);
        this.addArgumentValue(call, "NAME", restaurantName);
        this.insertSuccess *= this.getSession().executeNonSelectingCall((Call)call);
    }

    public void test() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("UPD_Menu");
        this.addArgumentValue(call, "ID", menuID);
        this.addArgumentValue(call, "REST_ID", restaurantID);
        this.addArgumentValue(call, "TYPE", menuTypeUpdate);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_Diner");
        this.addArgumentValue(call, "ID", dinerID);
        this.addArgumentValue(call, "F_NAME", dinerFirstNameUpdate);
        this.addArgumentValue(call, "CLASS", dinerClass);
        this.addArgumentValue(call, "L_NAME", dinerLastName);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_Person");
        this.addArgumentValue(call, "ID", personID);
        this.addArgumentValue(call, "F_NAME", personFirstNameUpdate);
        this.addArgumentValue(call, "CLASS", "A");
        this.addArgumentValue(call, "L_NAME", personLastName);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_Location");
        this.addArgumentValue(call, "AREA", locationAreaUpdate);
        this.addArgumentValue(call, "ID", locationID);
        this.addArgumentValue(call, "CITY", locationCity);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_Waiter");
        this.addArgumentValue(call, "ID", waiterID);
        this.addArgumentValue(call, "F_NAME", waiterFirstName);
        this.addArgumentValue(call, "SPECIALT", waiterSpecialityUpdate);
        this.addArgumentValue(call, "CLASS", "A");
        this.addArgumentValue(call, "W_RST_ID", restaurantID);
        this.addArgumentValue(call, "L_NAME", waiterLastName);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_MenuItem");
        this.addArgumentValue(call, "ID", menuItemID);
        this.addArgumentValue(call, "MENU_ID", menuID);
        this.addArgumentValue(call, "PRICE", menuItemPriceUpdate);
        this.addArgumentValue(call, "NAME", menuItemName);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("UPD_Restaurant");
        this.addArgumentValue(call, "ID", restaurantID);
        this.addArgumentValue(call, "NAME", restaurantNameUpdate);
        this.updateSuccess *= this.getSession().executeNonSelectingCall((Call)call);
    }

    public void reset() {
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("DEL_Menu");
        this.addArgumentValue(call, "ID", menuID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("D_1M_Menu_items");
        this.addArgumentValue(call, "ID", menuID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_Diner");
        this.addArgumentValue(call, "ID", dinerID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_Person");
        this.addArgumentValue(call, "ID", personID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_Location");
        this.addArgumentValue(call, "ID", locationID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_Waiter");
        this.addArgumentValue(call, "ID", waiterID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_MenuItem");
        this.addArgumentValue(call, "ID", menuItemID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("DEL_Restaurant");
        this.addArgumentValue(call, "ID", restaurantID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("D_1M_Restaurant_waiters");
        this.addArgumentValue(call, "ID", restaurantID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
        call = new StoredProcedureCall();
        call.setProcedureName("D_1M_Restaurant_menus");
        this.addArgumentValue(call, "ID", restaurantID);
        this.deleteSuccess *= this.getSession().executeNonSelectingCall((Call)call);
    }

    public void verify() {
        if (this.insertSuccess * this.updateSuccess * this.deleteSuccess == 0) {
            throw new TestErrorException("Failed to call stored procedures.");
        }
    }

    protected void addArgumentValue(StoredProcedureCall call, String name, Object value) {
        if (this.shouldUseNamedArguments) {
            call.addNamedArgumentValue(this.parameterNamePrefix + name, value);
        } else {
            call.addUnamedArgumentValue(value);
        }
    }
}

