/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.types.ExprType;

public class StaticContext {
    private final StaticContext theParent;
    private HashMap<String, Function> theFunctions;
    private HashMap<String, ExprVar> theVariables;

    StaticContext(StaticContext parent) {
        this.theParent = parent;
    }

    boolean isRoot() {
        return this.theParent == null;
    }

    void addVariable(ExprVar var) {
        if (this.theVariables == null) {
            this.theVariables = new HashMap();
        }
        if (this.theVariables.put(var.getName(), var) != null) {
            throw new QueryException("Duplicate declaration for variable " + var.getName(), var.getLocation());
        }
    }

    ExprVar findVariable(String name) {
        return this.findVariable(name, false);
    }

    ExprVar findVariable(String name, boolean local) {
        if (local) {
            if (this.theVariables == null) {
                return null;
            }
            ExprVar var = this.theVariables.get(name);
            return var;
        }
        ExprVar var = null;
        StaticContext sctx = this;
        while (var == null && sctx != null) {
            if (sctx.theVariables != null) {
                var = sctx.theVariables.get(name);
            }
            sctx = sctx.theParent;
        }
        return var;
    }

    public Map<String, VarInfo> getExternalVars() {
        HashMap<String, VarInfo> varsMap = new HashMap<String, VarInfo>();
        if (this.theVariables == null) {
            return varsMap;
        }
        for (Map.Entry<String, ExprVar> entry : this.theVariables.entrySet()) {
            String varName = entry.getKey();
            ExprVar var = entry.getValue();
            if (!var.isExternal()) continue;
            varsMap.put(varName, new VarInfo(var));
        }
        return varsMap;
    }

    void addFunction(Function func) {
        if (this.theFunctions == null) {
            this.theFunctions = new HashMap();
        }
        if (this.theFunctions.put(func.getName(), func) != null) {
            throw new QueryException("Duplicate declaration for function " + func.getName(), null);
        }
    }

    Function findFunction(String name, int arity) {
        return this.findFunction(name, arity, false);
    }

    Function findFunction(String name, int arity, boolean local) {
        Function func = null;
        if (local) {
            if (this.theFunctions == null) {
                return null;
            }
            func = this.theFunctions.get(name);
        } else {
            StaticContext sctx = this;
            while (func == null && sctx != null) {
                if (sctx.theFunctions != null) {
                    func = sctx.theFunctions.get(name);
                }
                sctx = sctx.theParent;
            }
        }
        if (func != null && !func.isVariadic() && arity != func.getArity()) {
            return null;
        }
        return func;
    }

    public static class VarInfo {
        private final int theId;
        private final ExprType theType;

        VarInfo(ExprVar var) {
            this.theId = var.getId();
            this.theType = var.getType();
        }

        private VarInfo(int id, ExprType type) {
            this.theId = id;
            this.theType = type;
        }

        public static VarInfo createVarInfo(int id, ExprType type) {
            return new VarInfo(id, type);
        }

        public int getId() {
            return this.theId;
        }

        public ExprType getType() {
            return this.theType;
        }
    }
}

