/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.QueryOptions;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryThrowExceptionTest
extends AutoVerifyTestCase {
    protected ReadObjectQuery query;
    protected boolean exceptionThrown = false;

    public MemoryQueryThrowExceptionTest() {
        this.setDescription("Test memory query throw indirection exception option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.query = (ReadObjectQuery)this.getSession().getDescriptor(Employee.class).getQueryManager().getQuery("memoryQueryThrowExceptionQuery");
        this.getSession().executeQuery((DatabaseQuery)this.query);
    }

    public void test() {
        ReadObjectQuery queryCopy = (ReadObjectQuery)this.query.clone();
        queryCopy.checkCacheOnly();
        queryCopy.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").equal((Object)"Montreal"));
        try {
            this.getSession().executeQuery((DatabaseQuery)queryCopy);
        }
        catch (QueryException exception) {
            this.exceptionThrown = exception.getErrorCode() == 6092;
        }
    }

    public void verify() {
        if (!this.exceptionThrown) {
            throw new TestErrorException("In Memory Query did not return all objects because of indirection");
        }
    }
}

