/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.validation.Address;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;
import org.eclipse.persistence.testing.tests.validation.PersonInstanceAccess;

public class IllegalArgumentWhileSettingValueThruInstanceVariableAccessorTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public IllegalArgumentWhileSettingValueThruInstanceVariableAccessorTest() {
        this.setDescription("This tests Illegal Argument While Setting Value Thru Instance Variable Accessor (TL-ERROR 32)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.illegalArgumentWhileSettingValueThruInstanceVariableAccessor(null, null, null, null);
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.orgDescriptor = this.getSession().getDescriptor(PersonInstanceAccess.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(PersonInstanceAccess.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        PersonInstanceAccess person = new PersonInstanceAccess();
        person.setName("Person");
        Address address = new Address();
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)person);
            uow.commit();
            DatabaseMapping dMapping = this.descriptor().getMappingForAttributeName("p_name");
            DatabaseMapping idMapping = this.descriptor().getMappingForAttributeName("p_id");
            dMapping.getAttributeAccessor().initializeAttributes(PersonInstanceAccess.class);
            idMapping.getAttributeAccessor().initializeAttributes(PersonInstanceAccess.class);
            dMapping.getAttributeAccessor().setAttributeValueInObject((Object)address, dMapping.getAttributeValueFromObject((Object)person));
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PersonInstanceAccess.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setAlias("EMPLOYEE");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping p_idMapping = new DirectToFieldMapping();
        p_idMapping.setAttributeName("p_id");
        p_idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)p_idMapping);
        DirectToFieldMapping p_nameMapping = new DirectToFieldMapping();
        p_nameMapping.setAttributeName("p_name");
        p_nameMapping.setFieldName("EMPLOYEE.F_NAME");
        descriptor.addMapping((DatabaseMapping)p_nameMapping);
        return descriptor;
    }
}

