/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.unitofwork.MutableAttributeObject;
import org.junit.Assert;

public class CloneAttributeIfMutableTest
extends TestCase {
    protected MutableAttributeObject original;
    protected MutableAttributeObject clone;

    public CloneAttributeIfMutableTest() {
        this.setDescription("Test that cloning an object also clones its attributes if their mappings are set as mutable");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = MutableAttributeObject.example1();
        this.clone = (MutableAttributeObject)uow.registerObject((Object)this.original);
        uow.release();
    }

    public void verify() {
        Vector<Throwable> errors = new Vector<Throwable>();
        try {
            Assert.assertNotSame((String)"1. original == clone", (Object)this.original, (Object)this.clone);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"2. original.getByteArray() == clone.getByteArray()", (Object)this.original.getByteArray(), (Object)this.clone.getByteArray());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"3. original.getUtilCalendar() == clone.getUtilCalendar()", (Object)this.original.getUtilCalendar(), (Object)this.clone.getUtilCalendar());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"4. original.getUtilDate() == clone.getUtilDate()", (Object)this.original.getUtilDate(), (Object)this.clone.getUtilDate());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"5. original.getSqlDate() == clone.getSqlDate()", (Object)this.original.getSqlDate(), (Object)this.clone.getSqlDate());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"6. original.getSqlTime() == clone.getSqlTime()", (Object)this.original.getSqlTime(), (Object)this.clone.getSqlTime());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"7. original.getSqlTimestamp() == clone.getSqlTimestamp()", (Object)this.original.getSqlTimestamp(), (Object)this.clone.getSqlTimestamp());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        try {
            Assert.assertNotSame((String)"8. original.getDateSubclass() == clone.getDateSubclass()", (Object)this.original.getDateSubclass(), (Object)this.clone.getDateSubclass());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        if (!errors.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The following assertions failed:");
            buffer.append(Helper.cr());
            for (int i = 0; i < errors.size(); ++i) {
                Throwable t = (Throwable)errors.get(i);
                buffer.append(t);
                buffer.append(Helper.cr());
            }
            throw new TestErrorException(buffer.toString());
        }
    }
}

