/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning.model;

import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.returning.ProjectAndDatabaseAdapter;
import org.eclipse.persistence.testing.tests.returning.model.ReturnObjectControl;

public abstract class AdapterWithReturnObjectControl
implements ProjectAndDatabaseAdapter,
ReturnObjectControl {
    @Override
    public boolean isOriginalSetupRequired() {
        return false;
    }

    @Override
    public abstract void updateProject(Project var1, Session var2);

    @Override
    public abstract void updateDatabase(Session var1);

    @Override
    public Object getObjectForInsert(Session session, Object objectToInsert) {
        ClassDescriptor desc = session.getClassDescriptor(objectToInsert);
        AbstractRecord rowToInsert = desc.getObjectBuilder().buildRow(objectToInsert, (AbstractSession)session, DatabaseMapping.WriteType.INSERT);
        DataRecord rowReturn = this.getRowForInsert((DataRecord)rowToInsert);
        if (rowReturn != null && !rowReturn.isEmpty()) {
            DatabaseRecord row = new DatabaseRecord(rowToInsert.size());
            row.putAll((Map)rowToInsert);
            row.putAll((Map)rowReturn);
            return this.readObjectFromRow(session, desc, (DataRecord)row);
        }
        return objectToInsert;
    }

    @Override
    public Object getObjectForUpdate(Session session, Object objectToUpdateBeforeChange, Object objectToUpdateAfterChange, boolean useUOW) {
        ClassDescriptor desc = session.getClassDescriptor(objectToUpdateBeforeChange);
        AbstractRecord rowBeforeChange = desc.getObjectBuilder().buildRow(objectToUpdateBeforeChange, (AbstractSession)session, DatabaseMapping.WriteType.UPDATE);
        AbstractRecord rowAfterChange = desc.getObjectBuilder().buildRow(objectToUpdateAfterChange, (AbstractSession)session, DatabaseMapping.WriteType.UPDATE);
        DatabaseRecord rowChange = new DatabaseRecord();
        this.getChange((DataRecord)rowChange, session, objectToUpdateBeforeChange, objectToUpdateAfterChange, desc, useUOW, DatabaseMapping.WriteType.UPDATE);
        DataRecord rowReturn = this.getRowForUpdate((DataRecord)rowChange);
        if (rowReturn != null && !rowReturn.isEmpty()) {
            DatabaseRecord row = new DatabaseRecord(rowAfterChange.size());
            row.putAll((Map)rowAfterChange);
            row.putAll((Map)rowReturn);
            return this.readObjectFromRow(session, desc, (DataRecord)row);
        }
        return objectToUpdateAfterChange;
    }

    public void getChange(DataRecord row, Session session, Object object1, Object object2, ClassDescriptor desc, boolean useUOW, DatabaseMapping.WriteType writeType) {
        Enumeration mappings = desc.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
            if (mapping.isReadOnly()) continue;
            this.getChange(row, mapping, session, object1, object2, useUOW, writeType);
        }
    }

    public void getChange(DataRecord row, DatabaseMapping mapping, Session session, Object object1, Object object2, boolean useUOW, DatabaseMapping.WriteType writeType) {
        if (mapping.isAggregateObjectMapping()) {
            Object aggregate1 = mapping.getAttributeValueFromObject(object1);
            Object aggregate2 = mapping.getAttributeValueFromObject(object2);
            if (aggregate1 == null && aggregate2 == null) {
                if (!useUOW) {
                    mapping.writeFromObjectIntoRow(object2, (AbstractRecord)((DatabaseRecord)row), (AbstractSession)session, writeType);
                }
            } else if (aggregate1 != null && aggregate2 != null && aggregate1.getClass().equals(aggregate2.getClass())) {
                ClassDescriptor desc = mapping.getReferenceDescriptor();
                this.getChange(row, session, aggregate1, aggregate2, desc, useUOW, writeType);
            } else {
                mapping.writeFromObjectIntoRow(object2, (AbstractRecord)((DatabaseRecord)row), (AbstractSession)session, writeType);
            }
        } else {
            DatabaseRecord row1 = new DatabaseRecord();
            DatabaseRecord row2 = new DatabaseRecord();
            mapping.writeFromObjectIntoRow(object1, (AbstractRecord)row1, (AbstractSession)session, writeType);
            mapping.writeFromObjectIntoRow(object2, (AbstractRecord)row2, (AbstractSession)session, writeType);
            for (int i = 0; i < row1.size(); ++i) {
                boolean changed;
                DatabaseField field = (DatabaseField)row1.getFields().elementAt(i);
                Object valueBefore = row1.getValues().elementAt(i);
                Object valueAfter = row2.get(field);
                if (valueAfter == null) {
                    changed = valueBefore != null;
                } else {
                    boolean bl = changed = !valueAfter.equals(valueBefore);
                }
                if (!changed) continue;
                row.put((Object)field, valueAfter);
            }
        }
    }

    protected Object readObjectFromRow(Session session, ClassDescriptor desc, DataRecord row) {
        if (desc.hasInheritance()) {
            Class newClass = desc.getInheritancePolicy().classFromRow((AbstractRecord)((DatabaseRecord)row), (AbstractSession)session);
            desc = session.getClassDescriptor(newClass);
        }
        Object object = desc.getObjectBuilder().buildNewInstance();
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession((AbstractSession)session);
        Enumeration mappings = desc.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
            mapping.readFromRowIntoObject((AbstractRecord)((DatabaseRecord)row), query.getJoinedAttributeManager(), object, null, (ObjectBuildingQuery)query, query.getSession(), true);
        }
        return object;
    }

    protected DataRecord getRowForInsert(DataRecord rowToInsert) {
        return null;
    }

    protected DataRecord getRowForUpdate(DataRecord rowChange) {
        return null;
    }
}

