/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class QueryTimeoutTest
extends TestCase {
    private boolean limitExceed;

    public QueryTimeoutTest() {
        this.setDescription("Test the query timeout setting");
        this.limitExceed = false;
    }

    public void test() {
        block5: {
            if (this.getSession().getLogin().getPlatform().isSymfoware()) {
                this.throwWarning("Test QueryTimeoutTest skipped for this platform, the driver does not support query timeout. (bug 304905)");
            }
            if (this.getSession().getPlatform().isMaxDB()) {
                this.throwWarning("Test QueryTimeoutTest skipped for this platform, the driver does not support query timeout. (bug 326503)");
            }
            if (this.getSession().getPlatform().isHANA()) {
                this.throwWarning("Test QueryTimeoutTest skipped for this platform, the driver does not support query timeout. (bug 384135)");
            }
            try {
                DataReadQuery query = new DataReadQuery();
                query.setSQLString("SELECT SUM(e.EMP_ID) from EMPLOYEE e , EMPLOYEE b, EMPLOYEE c, EMPLOYEE d, EMPLOYEE f, EMPLOYEE g, EMPLOYEE h, EMPLOYEE g");
                query.setQueryTimeout(1);
                this.getSession().executeQuery((DatabaseQuery)query);
            }
            catch (Exception e) {
                if (!(e instanceof DatabaseException)) break block5;
                this.limitExceed = true;
            }
        }
    }

    public void verify() {
        if (!this.limitExceed) {
            throw new TestErrorException("Timeout did not occur.");
        }
    }
}

