/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.legacy.Computer;
import org.eclipse.persistence.testing.models.legacy.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformResultsInUnitOfWorkTest;

public class ConformResultsAcrossOneToOneTest
extends ConformResultsInUnitOfWorkTest {
    Object comparedObject;
    int operator;
    static int EQUAL = 0;
    static int NOT_EQUAL = 1;
    static int IS_NULL = 2;
    static int NOT_NULL = 3;

    public ConformResultsAcrossOneToOneTest() {
        this(EQUAL);
    }

    public ConformResultsAcrossOneToOneTest(int operator) {
        this.operator = operator;
        Object nameString = this.getName();
        if (operator == EQUAL) {
            nameString = (String)nameString + "( EQUAL )";
        }
        if (operator == IS_NULL) {
            nameString = (String)nameString + "( IS NULL )";
        }
        if (operator == NOT_EQUAL) {
            nameString = (String)nameString + "( NOT EQUAL )";
        }
        if (operator == NOT_NULL) {
            nameString = (String)nameString + "( NOT NULL )";
        }
        this.setName((String)nameString);
    }

    @Override
    public void buildConformQuery() {
        this.conformedQuery = new ReadObjectQuery();
        this.conformedQuery.setReferenceClass(Computer.class);
        this.conformedQuery.conformResultsInUnitOfWork();
        this.conformedQuery.setSelectionCriteria(this.buildFullExpression(new ExpressionBuilder().get("employee"), this.comparedObject));
    }

    public Expression buildFullExpression(Expression partialExpression, Object object) {
        if (this.operator == EQUAL) {
            return partialExpression.equal(object);
        }
        if (this.operator == NOT_EQUAL) {
            return partialExpression.notEqual(object);
        }
        if (this.operator == IS_NULL) {
            return partialExpression.isNull();
        }
        if (this.operator == NOT_NULL) {
            return partialExpression.notNull();
        }
        throw new TestErrorException("operator not supported");
    }

    @Override
    public void prepareTest() {
        this.comparedObject = this.getSession().readObject(Employee.class);
        if (this.operator == IS_NULL) {
            Computer c = (Computer)this.getSession().readObject(Computer.class);
            c.setEmployee(null);
            this.getDatabaseSession().writeObject((Object)c);
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void setup() {
        super.setup();
    }

    @Override
    public void verify() {
        if (this.result == null) {
            throw new TestErrorException("object existed in database but not returned in query");
        }
        Computer computer = (Computer)this.result;
        if (this.operator == IS_NULL) {
            if (computer.employee != null) {
                throw new TestErrorException("Wrong object has been returned.");
            }
            return;
        }
        if (this.operator == NOT_NULL) {
            if (computer.employee == null) {
                throw new TestErrorException("Wrong object has been returned.");
            }
            return;
        }
        if (this.operator == EQUAL) {
            if (computer.employee.firstName != ((Employee)this.comparedObject).firstName || computer.employee.lastName != ((Employee)this.comparedObject).lastName) {
                throw new TestErrorException("Wrong object has been returned.");
            }
            return;
        }
        if (this.operator == NOT_EQUAL && computer.employee.firstName == ((Employee)this.comparedObject).firstName && computer.employee.lastName == ((Employee)this.comparedObject).lastName) {
            throw new TestErrorException("Wrong object has been returned.");
        }
    }
}

