/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.jpql.BaseTestCase;
import org.eclipse.persistence.testing.tests.jpql.DomainObjectComparer;

public class JPQLTestCase
extends TransactionalTestCase {
    private String ejbql;
    protected ObjectLevelReadQuery theQuery = null;
    private Class<?> referenceClass;
    private Expression originalExpression = null;
    private Object originalObject;
    private DomainObjectComparer comparer = null;
    private Object returnedObjects;
    public boolean useReportQuery = false;
    private Vector arguments = null;
    protected Vector supportedPlatforms;
    protected Vector unsupportedPlatforms;

    public JPQLTestCase() {
    }

    public JPQLTestCase(String ejbqlString) {
        this();
        this.ejbql = ejbqlString;
    }

    public JPQLTestCase(ObjectLevelReadQuery theQuery) {
        this();
        this.theQuery = theQuery;
        this.ejbql = ((JPQLCallQueryMechanism)theQuery.getQueryMechanism()).getJPQLCall().getEjbqlString();
    }

    public JPQLTestCase(String ejbqlString, ObjectLevelReadQuery theQuery) {
        this();
        this.ejbql = ejbqlString;
        this.theQuery = theQuery;
    }

    public JPQLTestCase(String ejbqlString, ObjectLevelReadQuery theQuery, Class<?> theReferenceClass) {
        this();
        this.ejbql = ejbqlString;
        this.theQuery = theQuery;
        this.referenceClass = theReferenceClass;
    }

    public static JPQLTestCase getBaseTestCase() {
        return new BaseTestCase();
    }

    public Vector getAttributeFromAll(String attributeName, Vector objects) {
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(this.getReferenceClass());
        DirectToFieldMapping mapping = (DirectToFieldMapping)descriptor.getMappingForAttributeName(attributeName);
        Vector<Object> attributes = new Vector<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            Object currentObject = objects.elementAt(i);
            if (currentObject.getClass() == ReportQueryResult.class) {
                attributes.addElement(((ReportQueryResult)currentObject).get(attributeName));
                continue;
            }
            attributes.addElement(mapping.getAttributeValueFromObject(currentObject));
        }
        return attributes;
    }

    public void reset() {
        this.setQuery(null);
        super.reset();
    }

    public Employee getEmployeeWithRequiredNameLength(int minFirstNameLength, String testName) {
        return this.getEmployeeWithRequiredNameLength(this.getSomeEmployees(), minFirstNameLength, testName);
    }

    public Employee getEmployeeWithRequiredNameLength(Vector vectorOfEmployees, int minFirstNameLength, String testName) {
        Employee empMatch = null;
        Vector employees = vectorOfEmployees;
        for (int i = 0; i < employees.size(); ++i) {
            empMatch = (Employee)employees.get(i);
            String firstName = empMatch.getFirstName();
            if (firstName.length() < minFirstNameLength) continue;
            i = employees.size();
        }
        if (null == empMatch) {
            throw new RuntimeException(testName + " Setup Failed: unable to find an Employee with firstName size of at least  " + minFirstNameLength);
        }
        return empMatch;
    }

    public void setup() {
        if (!this.isPlatformSupported((DatabasePlatform)this.getSession().getLogin().getPlatform())) {
            throw new TestWarningException("This EJBQL is not supported on this platform.");
        }
        if (this.getReferenceClass() == null) {
            this.setReferenceClass(Employee.class);
        }
        this.getQuery().setEJBQLString(this.getEjbqlString());
    }

    public void test() throws Exception {
        this.getSession().logMessage("Running EJBQL -> " + this.getEjbqlString());
        this.executeEJBQLQuery();
    }

    public void executeEJBQLQuery() throws Exception {
        if (this.hasArguments()) {
            this.addArgumentNamesToQuery();
            this.setReturnedObjects(this.getSession().executeQuery((DatabaseQuery)this.getQuery(), (List)this.getArguments()));
        } else {
            this.setReturnedObjects(this.getSession().executeQuery((DatabaseQuery)this.getQuery()));
        }
    }

    private void addArgumentNamesToQuery() {
        for (int argumentIndex = 1; argumentIndex <= this.getArguments().size(); ++argumentIndex) {
            this.getQuery().addArgument(String.valueOf(argumentIndex));
        }
    }

    public void verify() throws Exception {
        if (!this.getComparer().compareObjects(this.getOriginalObject(), this.getReturnedObjects())) {
            throw new TestErrorException(this.getName() + " Verify Failed:" + this.getOriginalObject() + " != " + this.getReturnedObjects());
        }
    }

    public Vector getSomeProjects() {
        return this.getSession().readAllObjects(Project.class);
    }

    public Vector getSomeAddresses() {
        return this.getSession().readAllObjects(Address.class);
    }

    public Vector getSomeEmployees() {
        return this.getSession().readAllObjects(Employee.class);
    }

    public void setEjbqlString(String theEjbqlString) {
        this.ejbql = theEjbqlString;
    }

    public String getEjbqlString() {
        return this.ejbql;
    }

    public ObjectLevelReadQuery getQuery() {
        if (this.theQuery == null) {
            if (this.shouldUseReportQuery()) {
                this.setQuery((ObjectLevelReadQuery)this.buildReportQuery());
            } else {
                this.setQuery((ObjectLevelReadQuery)new ReadAllQuery());
            }
            this.getQuery().setEJBQLString(this.getEjbqlString());
        }
        return this.theQuery;
    }

    public ReportQuery buildReportQuery() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.dontRetrievePrimaryKeys();
        reportQuery.returnSingleAttribute();
        return reportQuery;
    }

    public void setQuery(ObjectLevelReadQuery theQuery) {
        this.theQuery = theQuery;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public void setReferenceClass(Class<?> theClass) {
        this.referenceClass = theClass;
    }

    public Object getReturnedObjects() {
        return this.returnedObjects;
    }

    public void setReturnedObjects(Object theReturnedObjects) {
        this.returnedObjects = theReturnedObjects;
    }

    public DomainObjectComparer getComparer() {
        if (this.comparer == null) {
            this.setComparer(new DomainObjectComparer());
            this.getComparer().setSession(this.getSession());
        }
        return this.comparer;
    }

    public Expression getOriginalObjectExpression() {
        return this.originalExpression;
    }

    public void setOriginalObjectExpression(Expression theOriginalExpression) {
        this.originalExpression = theOriginalExpression;
    }

    public void setComparer(DomainObjectComparer theComparer) {
        this.comparer = theComparer;
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public void setOriginalOject(Object theObject) {
        this.originalObject = theObject;
    }

    public void useReportQuery() {
        this.useReportQuery = true;
    }

    public boolean shouldUseReportQuery() {
        return this.getUseReportQuery();
    }

    public boolean getUseReportQuery() {
        return this.useReportQuery;
    }

    public void setUseReportQuery(boolean useReportQuery) {
        this.useReportQuery = useReportQuery;
    }

    public Vector getArguments() {
        return this.arguments;
    }

    public void setArguments(Vector newArguments) {
        this.arguments = newArguments;
    }

    public boolean hasArguments() {
        return this.getArguments() != null;
    }

    public boolean isPlatformSupported(DatabasePlatform platform) {
        boolean supported = false;
        boolean notSupported = false;
        if (this.unsupportedPlatforms == null && this.supportedPlatforms == null) {
            return true;
        }
        if (this.supportedPlatforms != null) {
            for (Class platformClass : this.supportedPlatforms) {
                if (!platformClass.isInstance(platform)) continue;
                supported = true;
            }
        } else {
            supported = true;
        }
        if (this.unsupportedPlatforms != null) {
            for (Class platformClass : this.unsupportedPlatforms) {
                if (!platformClass.isInstance(platform)) continue;
                notSupported = true;
            }
        }
        return supported && !notSupported;
    }

    public void addSupportedPlatform(Class<?> platform) {
        if (this.supportedPlatforms == null) {
            this.supportedPlatforms = new Vector();
        }
        this.supportedPlatforms.addElement(platform);
    }

    public void addUnsupportedPlatform(Class<?> platform) {
        if (this.unsupportedPlatforms == null) {
            this.unsupportedPlatforms = new Vector();
        }
        this.unsupportedPlatforms.addElement(platform);
    }
}

