/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateDirectMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.tests.collections.map.TestReadAggregateDirectMapMapping;

public class TestUpdateAggregateDirectMapMapping
extends TestReadAggregateDirectMapMapping {
    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(AggregateDirectMapHolder.class, this.holderExp);
        AggregateDirectMapHolder holder = (AggregateDirectMapHolder)this.holders.get(0);
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(1);
        holder.removeAggregateToDirectMapItem(mapKey);
        mapKey = new AggregateMapKey();
        mapKey.setKey(3);
        holder.addAggregateToDirectMapItem(mapKey, 3);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)holder);
        if (!this.compareObjects(holder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object changedHolder = this.holders.get(0);
        this.holders = this.getSession().readAllObjects(AggregateDirectMapHolder.class, this.holderExp);
        AggregateDirectMapHolder holder = (AggregateDirectMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(1);
        if (holder.getAggregateToDirectMap().containsKey(mapKey)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        mapKey = new AggregateMapKey();
        mapKey.setKey(3);
        Integer value = (Integer)holder.getAggregateToDirectMap().get(mapKey);
        if (value != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
    }
}

