/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.Language;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;

public class CheckForNullUnitOfWorkTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public UnitOfWork nestedUnitOfWork;

    public CheckForNullUnitOfWorkTest() {
    }

    public CheckForNullUnitOfWorkTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Employee employee = (Employee)this.unitOfWorkWorkingCopy;
        AddressDescription addressDescription = employee.getAddressDescription();
        ProjectDescription projectDescription = employee.getProjectDescription();
        employee.setFirstName(null);
        employee.setLastName(null);
        addressDescription.setPeriodDescription(null);
        projectDescription.getComputer().setValue(null);
        projectDescription.getResponsibilities().setValue(null);
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        Language language = (Language)languages.firstElement();
        language.setLanguage(null);
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commit();
    }

    protected void verify() {
        if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
            throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
        }
        super.verify();
    }
}

