/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unidirectional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.ReadAllCallTest;
import org.eclipse.persistence.testing.framework.ReadAllCallWithOrderingTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectCallTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicInsertObjectTest;
import org.eclipse.persistence.testing.models.unidirectional.Employee;
import org.eclipse.persistence.testing.models.unidirectional.EmployeePopulator;
import org.eclipse.persistence.testing.models.unidirectional.EmployeeSystem;
import org.eclipse.persistence.testing.models.unidirectional.PhoneNumber;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class UnidirectionalEmployeeBasicTestModel
extends TestModel {
    public static junit.framework.TestSuite suite() {
        return new UnidirectionalEmployeeBasicTestModel();
    }

    public UnidirectionalEmployeeBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the unidirectionl employee demo.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)UnidirectionalEmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)UnidirectionalEmployeeBasicTestModel.getComplexUpdateObjectTestSuite());
        this.addTest((Test)UnidirectionalEmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)UnidirectionalEmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)UnidirectionalEmployeeBasicTestModel.getReadAllTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new TargetLockingTest_DeleteSource(true));
        suite.addTest((Test)new TargetLockingTest_DeleteSource(false));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUOWBasicInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo using uow.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample5()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllCallTest(Employee.class, 12, (Call)new SQLCall("SELECT VERSION, EMP_ID, L_NAME, F_NAME FROM UNIDIR_EMPLOYEE")));
        Expression orderBy = new ExpressionBuilder().get("firstName").ascending();
        SQLCall call = new SQLCall("SELECT VERSION, EMP_ID, L_NAME, F_NAME FROM UNIDIR_EMPLOYEE");
        suite.addTest((Test)new ReadAllCallWithOrderingTest(Employee.class, 12, (Call)call, orderBy));
        suite.addTest((Test)new JoinTest());
        suite.addTest((Test)new JoinTest_SelectByFirstName());
        suite.addTest((Test)new BatchReadingTest());
        suite.addTest((Test)new BatchReadingTest_SelectByFirstName());
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Employee employee = (Employee)manager.getObject(employeeClass, "0001");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT VERSION, EMP_ID, L_NAME, F_NAME FROM UNIDIR_EMPLOYEE WHERE F_NAME = '" + employee.getFirstName() + "' AND L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0002");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT VERSION, EMP_ID, L_NAME, F_NAME FROM UNIDIR_EMPLOYEE WHERE F_NAME = '" + employee.getFirstName() + "' AND L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0003");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT VERSION, EMP_ID, L_NAME, F_NAME FROM UNIDIR_EMPLOYEE WHERE F_NAME = '" + employee.getFirstName() + "' AND L_NAME = '" + employee.getLastName() + "'")));
        return suite;
    }

    public static TestSuite getComplexUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeComplexUpdateTestSuite");
        suite.setDescription("This suite tests the updating of each an employee by adding and/or removing managed employees and/or phones.");
        Class<Employee> employeeClass = Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee originalEmployee = (Employee)manager.getObject(employeeClass, "0001");
        Employee otherEmployee = (Employee)manager.getObject(employeeClass, "0002");
        suite.addTest((Test)new EmployeeComplexUpdateTest(originalEmployee, otherEmployee.getManagedEmployees().get(0), originalEmployee.getManagedEmployees().get(0)));
        suite.addTest((Test)new EmployeeComplexUpdateTest(originalEmployee, (Object)null, originalEmployee.getPhoneNumbers().get(0)));
        Employee newEmployee = new Employee();
        newEmployee.setFirstName("New");
        PhoneNumber newPhoneNumber = new PhoneNumber("home", "001", "0000001");
        suite.addTest((Test)new EmployeeComplexUpdateTest(originalEmployee, new Object[]{otherEmployee.getManagedEmployees().get(0), newEmployee, newPhoneNumber}, new Object[]{originalEmployee.getManagedEmployees().get(0), originalEmployee.getManagedEmployees().get(1), originalEmployee.getPhoneNumbers().get(0)}));
        suite.addTest((Test)new CascadeLockingTest());
        suite.addTest((Test)new TargetLockingTest_AddRemoveTarget());
        return suite;
    }

    static class TargetLockingTest_DeleteSource
    extends TargetLockingTest {
        boolean isIndirectionTriggered;

        public TargetLockingTest_DeleteSource(boolean isIndirectionTriggered) {
            this.isIndirectionTriggered = isIndirectionTriggered;
            this.setName("TargetLockingTest_DeleteSource");
            if (isIndirectionTriggered) {
                this.setName(this.getName() + "_IndirectionTriggered");
            } else {
                this.setName(this.getName() + "_IndirectionNotTriggered");
            }
            this.setDescription("Tests target optimistic locking for UnidirectionalOneToManyMapping when the source is deleted.");
        }

        public void setup() {
            this.employee = new Employee[3];
            this.employee[0] = new Employee();
            this.employee[0].setFirstName("Manager");
            this.employee[1] = new Employee();
            this.employee[1].setFirstName("Employee_1");
            this.employee[0].addManagedEmployee(this.employee[1]);
            this.employee[2] = new Employee();
            this.employee[2].setFirstName("Employee_2");
            this.employee[0].addManagedEmployee(this.employee[2]);
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            for (int i = 0; i < this.employee.length; ++i) {
                uow.registerObject((Object)this.employee[i]);
            }
            uow.commit();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }

        public void test() {
            this.employee[0] = (Employee)this.getSession().readObject((Object)this.employee[0]);
            if (this.isIndirectionTriggered) {
                this.employee[0].getManagedEmployees().size();
            }
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Employee managerClone = (Employee)uow.deleteObject((Object)this.employee[0]);
            uow.commit();
            this.employee[0] = null;
        }

        public void verify() {
            int i;
            long[] version = new long[this.employee.length];
            Object errorMsg = "";
            for (i = 1; i < this.employee.length; ++i) {
                version[i] = this.getVersion(this.employee[i]);
                if (version[i] == 2L) continue;
                errorMsg = (String)errorMsg + "in the cache version[" + i + "] = " + version[i] + " (2 was expected); ";
            }
            for (i = 1; i < this.employee.length; ++i) {
                this.employee[i] = (Employee)this.getSession().refreshObject((Object)this.employee[i]);
                version[i] = this.getVersion(this.employee[i]);
                if (version[i] == 2L) continue;
                errorMsg = (String)errorMsg + "in the db version[" + i + "] = " + version[i] + " (2 was expected); ";
            }
            if (((String)errorMsg).length() > 0) {
                throw new TestErrorException((String)errorMsg);
            }
        }
    }

    static class JoinTest
    extends TestCase {
        public JoinTest() {
            this.setName("JoinTest - no selection criteria");
            this.setDescription("Tests reading of Employees with join expressions anyOf(managedEmployees) and anyOf(managedEmployees).anyOf(phoneNumbers)");
        }

        void setSelectionCriteria(ReadAllQuery query) {
        }

        public void test() {
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Employee.class);
            this.setSelectionCriteria(query);
            ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
            Expression employees = query.getExpressionBuilder().anyOf("managedEmployees");
            query.addJoinedAttribute(employees);
            Expression phones = employees.anyOf("phoneNumbers");
            query.addJoinedAttribute(phones);
            String errorMsg = JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query, (AbstractSession)((AbstractSession)this.getSession()));
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }
    }

    static class JoinTest_SelectByFirstName
    extends JoinTest {
        public JoinTest_SelectByFirstName() {
            this.setName("JoinTest - select by first name");
        }

        @Override
        void setSelectionCriteria(ReadAllQuery query) {
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").like("J%"));
        }
    }

    static class BatchReadingTest
    extends TestCase {
        boolean shouldPrintDebugOutput = false;

        public BatchReadingTest() {
            this.setName("EmployeeBatchReadingTest - no selection criteria");
            this.setDescription("Tests batch reading of Employees with batch expression managedEmployees.phoneNumbers");
        }

        void setSelectionCriteria(ReadAllQuery query) {
        }

        public void test() {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            ReadAllQuery query = new ReadAllQuery(Employee.class);
            this.setSelectionCriteria(query);
            ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
            Expression managedEmployees = query.getExpressionBuilder().get("managedEmployees");
            Expression managedEmployeesPhoneNumbers = managedEmployees.get("phoneNumbers");
            query.addBatchReadAttribute(managedEmployeesPhoneNumbers);
            List employees = (List)this.getSession().executeQuery((DatabaseQuery)query);
            if (employees.isEmpty()) {
                throw new TestProblemException("No Employees were read");
            }
            this.printDebug("Trigger batch reading results");
            boolean isConnected = true;
            for (int i = 0; i < employees.size(); ++i) {
                Employee manager = (Employee)employees.get(i);
                if (!manager.getManagedEmployees().isEmpty()) {
                    this.printDebug("Manager = " + manager);
                    for (int j = 0; j < manager.getManagedEmployees().size(); ++j) {
                        Employee emp = (Employee)manager.getManagedEmployees().get(j);
                        this.printDebug("     " + emp);
                        for (int k = 0; k < emp.getPhoneNumbers().size(); ++k) {
                            if (isConnected) {
                                ((AbstractSession)this.getSession()).getAccessor().closeConnection();
                                isConnected = false;
                            }
                            PhoneNumber phone = (PhoneNumber)emp.getPhoneNumbers().get(k);
                            this.printDebug("          " + phone);
                        }
                    }
                    continue;
                }
                this.printDebug(manager.toString());
            }
            if (!isConnected) {
                ((AbstractSession)this.getSession()).getAccessor().reestablishConnection((AbstractSession)this.getSession());
            }
            this.printDebug("");
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            List controlEmployees = (List)this.getSession().executeQuery((DatabaseQuery)controlQuery);
            this.printDebug("Trigger control results");
            for (int i = 0; i < controlEmployees.size(); ++i) {
                Employee manager = (Employee)controlEmployees.get(i);
                if (!manager.getManagedEmployees().isEmpty()) {
                    this.printDebug("Manager = " + manager);
                    for (int j = 0; j < manager.getManagedEmployees().size(); ++j) {
                        Employee emp = (Employee)manager.getManagedEmployees().get(j);
                        this.printDebug("     " + emp);
                        for (int k = 0; k < emp.getPhoneNumbers().size(); ++k) {
                            PhoneNumber phone = (PhoneNumber)emp.getPhoneNumbers().get(k);
                            this.printDebug("          " + phone);
                        }
                    }
                    continue;
                }
                this.printDebug(manager.toString());
            }
            String errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)employees, (Collection)controlEmployees, (ClassDescriptor)this.getSession().getClassDescriptor(Employee.class), (AbstractSession)((AbstractSession)this.getSession()));
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }

        void printDebug(String msg) {
            if (this.shouldPrintDebugOutput) {
                System.out.println(msg);
            }
        }
    }

    static class BatchReadingTest_SelectByFirstName
    extends BatchReadingTest {
        public BatchReadingTest_SelectByFirstName() {
            this.setName("EmployeeBatchReadingTest - select by first name");
        }

        @Override
        void setSelectionCriteria(ReadAllQuery query) {
            query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").like("J%"));
        }
    }

    static class EmployeeComplexUpdateTest
    extends ComplexUpdateTest {
        List<Employee> managedEmployeesToAdd;
        List<Employee> managedEmployeesToRemove;
        List<PhoneNumber> phonesToAdd;
        List<PhoneNumber> phonesToRemove;

        public EmployeeComplexUpdateTest(Employee originalEmployee, List objectsToAdd, Object objectToRemove) {
            Object[] objectArray;
            Object[] objectArray2 = objectsToAdd != null ? objectsToAdd.toArray() : null;
            if (objectToRemove != null) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = objectToRemove;
            } else {
                objectArray = null;
            }
            this(originalEmployee, objectArray2, objectArray);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, Object objectToAdd, List objectsToRemove) {
            Object[] objectArray;
            if (objectToAdd != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = objectToAdd;
            } else {
                objectArray = null;
            }
            this(originalEmployee, objectArray, objectsToRemove != null ? objectsToRemove.toArray() : null);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, List objectsToAdd, List objectsToRemove) {
            this(originalEmployee, objectsToAdd != null ? objectsToAdd.toArray() : null, objectsToRemove != null ? objectsToRemove.toArray() : null);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, Object objectToAdd, Object objectToRemove) {
            Object[] objectArray;
            Object[] objectArray2;
            if (objectToAdd != null) {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = objectToAdd;
            } else {
                objectArray2 = null;
            }
            if (objectToRemove != null) {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = objectToRemove;
            } else {
                objectArray = null;
            }
            this(originalEmployee, objectArray2, objectArray);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, Object[] objectsToAdd, Object objectToRemove) {
            Object[] objectArray;
            if (objectToRemove != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = objectToRemove;
            } else {
                objectArray = null;
            }
            this(originalEmployee, objectsToAdd, objectArray);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, Object objectToAdd, Object[] objectsToRemove) {
            Object[] objectArray;
            if (objectToAdd != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = objectToAdd;
            } else {
                objectArray = null;
            }
            this(originalEmployee, objectArray, objectsToRemove);
        }

        public EmployeeComplexUpdateTest(Employee originalEmployee, Object[] objectsToAdd, Object[] objectsToRemove) {
            super(originalEmployee);
            int i;
            this.managedEmployeesToAdd = new ArrayList<Employee>();
            this.managedEmployeesToRemove = new ArrayList<Employee>();
            this.phonesToAdd = new ArrayList<PhoneNumber>();
            this.phonesToRemove = new ArrayList<PhoneNumber>();
            this.usesUnitOfWork = true;
            if (objectsToAdd != null) {
                for (i = 0; i < objectsToAdd.length; ++i) {
                    Object objectToAdd = objectsToAdd[i];
                    if (objectToAdd instanceof Employee) {
                        if (!originalEmployee.getManagedEmployees().contains(objectToAdd)) {
                            this.managedEmployeesToAdd.add((Employee)objectToAdd);
                            continue;
                        }
                        throw new TestWarningException("OriginalEmployee: " + originalEmployee + " already manages employee to be added: " + objectToAdd);
                    }
                    if (!originalEmployee.getPhoneNumbers().contains(objectToAdd)) {
                        this.phonesToAdd.add((PhoneNumber)objectToAdd);
                        continue;
                    }
                    throw new TestWarningException("OriginalEmployee: " + originalEmployee + " already has the phonee to be added: " + objectToAdd);
                }
            }
            if (objectsToRemove != null) {
                for (i = 0; i < objectsToRemove.length; ++i) {
                    Object objectToRemove = objectsToRemove[i];
                    if (objectToRemove instanceof Employee) {
                        if (originalEmployee.getManagedEmployees().contains(objectToRemove)) {
                            this.managedEmployeesToRemove.add((Employee)objectToRemove);
                            continue;
                        }
                        throw new TestWarningException("OriginalEmployee: " + originalEmployee + " doesn't manage employee to be removed: " + objectToRemove);
                    }
                    if (originalEmployee.getPhoneNumbers().contains(objectToRemove)) {
                        this.phonesToRemove.add((PhoneNumber)objectToRemove);
                        continue;
                    }
                    throw new TestWarningException("OriginalEmployee: " + originalEmployee + " doesn't have the phonee to be removed: " + objectToRemove);
                }
            }
            Object employeeString = "";
            if (this.managedEmployeesToAdd.size() > 0 || this.managedEmployeesToRemove.size() > 0) {
                Object addString = "";
                if (this.managedEmployeesToAdd.size() > 0) {
                    addString = "add " + this.managedEmployeesToAdd.size();
                }
                Object removeString = "";
                if (this.managedEmployeesToRemove.size() > 0) {
                    removeString = "remove " + this.managedEmployeesToRemove.size();
                }
                employeeString = (String)addString + (((String)addString).length() > 0 && ((String)removeString).length() > 0 ? " and " : " ") + (String)removeString + " Employees";
            }
            Object phoneString = "";
            if (this.phonesToAdd.size() > 0 || this.phonesToRemove.size() > 0) {
                Object addString = "";
                if (this.phonesToAdd.size() > 0) {
                    addString = "add " + this.phonesToAdd.size();
                }
                Object removeString = "";
                if (this.phonesToRemove.size() > 0) {
                    removeString = "remove " + this.phonesToRemove.size();
                }
                phoneString = (String)addString + (((String)addString).length() > 0 && ((String)removeString).length() > 0 ? " and " : "") + (String)removeString + " Phones";
            }
            this.setName("EmployeeComplexUpdateTest: " + (String)employeeString + (((String)employeeString).length() > 0 && ((String)phoneString).length() > 0 ? "; " : "") + (String)phoneString + ";");
            this.setDescription("The test updates original Employee object: " + this.originalObject.toString() + " from the database by adding and/or removing managedEmployees and/or PhoneNumbers and verifies that the object updated correctly.");
        }

        @Override
        public String getName() {
            String testName = super.getName();
            int lastIndex = testName.lastIndexOf(";");
            if (lastIndex > 0) {
                testName = testName.substring(0, lastIndex);
            }
            return testName;
        }

        @Override
        protected void changeObject() {
            int i;
            UnitOfWork uow = (UnitOfWork)this.getSession();
            Employee cloneEmployee = (Employee)this.workingCopy;
            for (i = 0; i < this.managedEmployeesToAdd.size(); ++i) {
                Employee cloneEmployeeToAdd = (Employee)uow.registerObject((Object)this.managedEmployeesToAdd.get(i));
                cloneEmployee.addManagedEmployee(cloneEmployeeToAdd);
            }
            for (i = 0; i < this.managedEmployeesToRemove.size(); ++i) {
                Employee cloneEmployeeToRemove = (Employee)uow.registerObject((Object)this.managedEmployeesToRemove.get(i));
                cloneEmployee.removeManagedEmployee(cloneEmployeeToRemove);
            }
            for (i = 0; i < this.phonesToRemove.size(); ++i) {
                PhoneNumber clonePhoneToRemove = (PhoneNumber)uow.registerObject((Object)this.phonesToRemove.get(i));
                cloneEmployee.removePhoneNumber(clonePhoneToRemove);
            }
            for (i = 0; i < this.phonesToAdd.size(); ++i) {
                PhoneNumber clonePhoneToAdd = (PhoneNumber)uow.registerObject((Object)this.phonesToAdd.get(i));
                cloneEmployee.addPhoneNumber(clonePhoneToAdd);
            }
        }

        @Override
        protected void setup() {
            int i;
            super.setup();
            for (i = 0; i < this.managedEmployeesToAdd.size(); ++i) {
                Employee readEmployeeToAdd = (Employee)this.readObject(this.managedEmployeesToAdd.get(i));
                if (readEmployeeToAdd == null) continue;
                this.managedEmployeesToAdd.set(i, readEmployeeToAdd);
            }
            for (i = 0; i < this.managedEmployeesToRemove.size(); ++i) {
                Employee readEmployeeToRemove = (Employee)this.readObject(this.managedEmployeesToRemove.get(i));
                if (readEmployeeToRemove == null) {
                    throw new TestWarningException("Employee to be removed: " + this.managedEmployeesToRemove.get(i) + " is not in the db");
                }
                this.managedEmployeesToRemove.set(i, readEmployeeToRemove);
            }
            for (i = 0; i < this.phonesToRemove.size(); ++i) {
                PhoneNumber readPhoneToRemove = (PhoneNumber)this.readObject(this.phonesToRemove.get(i));
                if (readPhoneToRemove == null) {
                    throw new TestWarningException("Phone to be removed: " + this.phonesToRemove.get(i) + " is not in the db");
                }
                this.phonesToRemove.set(i, readPhoneToRemove);
            }
            for (i = 0; i < this.phonesToAdd.size(); ++i) {
                PhoneNumber readPhoneToAdd = (PhoneNumber)this.readObject(this.phonesToAdd.get(i));
                if (readPhoneToAdd == null) continue;
                this.phonesToAdd.set(i, readPhoneToAdd);
            }
        }

        protected Object readObject(Object object) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setSelectionObject(object);
            return this.getSession().executeQuery((DatabaseQuery)query);
        }
    }

    static class CascadeLockingTest
    extends TransactionalTestCase {
        long[] version = new long[7];
        long[] versionExpected = new long[]{1L, 2L, 2L, 3L, 4L, 5L, 6L};

        public CascadeLockingTest() {
            this.setName("CascadeLockingPolicyTest");
            this.setDescription("Tests optimistic lock cascading for UnidirectionalOneToManyMapping");
        }

        public void setup() {
            super.setup();
            for (int i = 0; i < this.version.length; ++i) {
                this.version[i] = 0L;
            }
        }

        public void test() {
            Employee manager = new Employee();
            manager.setFirstName("Manager");
            Employee employee = new Employee();
            employee.setFirstName("Employee");
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            uow.registerObject((Object)manager);
            uow.registerObject((Object)employee);
            uow.commit();
            this.version[0] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            uow = this.getSession().acquireUnitOfWork();
            Employee managerClone = (Employee)uow.registerObject((Object)manager);
            Employee employeeClone = (Employee)uow.registerObject((Object)employee);
            managerClone.addManagedEmployee(employeeClone);
            uow.commit();
            this.version[1] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            uow = this.getSession().acquireUnitOfWork();
            employeeClone = (Employee)uow.registerObject((Object)employee);
            employeeClone.setFirstName("Altered");
            uow.commit();
            this.version[2] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            uow = this.getSession().acquireUnitOfWork();
            managerClone = (Employee)uow.registerObject((Object)manager);
            employeeClone = (Employee)uow.registerObject((Object)employee);
            managerClone.removeManagedEmployee(employeeClone);
            uow.commit();
            this.version[3] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            PhoneNumber phone = new PhoneNumber("home", "613", "1111111");
            uow = this.getSession().acquireUnitOfWork();
            managerClone = (Employee)uow.registerObject((Object)manager);
            PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
            managerClone.addPhoneNumber(phoneClone);
            uow.commit();
            this.version[4] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            uow = this.getSession().acquireUnitOfWork();
            phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
            phoneClone.setType("work");
            uow.commit();
            this.version[5] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
            uow = this.getSession().acquireUnitOfWork();
            managerClone = (Employee)uow.registerObject((Object)manager);
            phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
            managerClone.removePhoneNumber(phoneClone);
            uow.commit();
            this.version[6] = (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)manager, (Object)manager.getId(), this.getAbstractSession());
        }

        public void verify() {
            int numTestsFailed = 0;
            Object errorMsg = "";
            for (int i = 0; i < this.version.length; ++i) {
                if (this.version[i] + (long)numTestsFailed == this.versionExpected[i]) continue;
                ++numTestsFailed;
                errorMsg = (String)errorMsg + "test" + i + " failed; ";
            }
            if (numTestsFailed > 0) {
                throw new TestErrorException((String)errorMsg);
            }
        }
    }

    static class TargetLockingTest_AddRemoveTarget
    extends TargetLockingTest {
        public TargetLockingTest_AddRemoveTarget() {
            this.setName("TargetLockingTest_AddRemoveTarget");
            this.setDescription("Tests target optimistic locking for UnidirectionalOneToManyMapping when targets are added to and removed from the source.");
        }

        public void setup() {
            this.employee = new Employee[5];
            this.employee[0] = new Employee();
            this.employee[0].setFirstName("Manager");
            this.employee[1] = new Employee();
            this.employee[1].setFirstName("Employee_1");
            this.employee[0].addManagedEmployee(this.employee[1]);
            this.employee[2] = new Employee();
            this.employee[2].setFirstName("Employee_2");
            this.employee[0].addManagedEmployee(this.employee[2]);
            this.employee[3] = new Employee();
            this.employee[3].setFirstName("Employee_3");
            this.employee[4] = new Employee();
            this.employee[4].setFirstName("Employee_4");
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            for (int i = 0; i < this.employee.length; ++i) {
                uow.registerObject((Object)this.employee[i]);
            }
            uow.commit();
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Employee managerClone = (Employee)uow.registerObject((Object)this.employee[0]);
            managerClone.getManagedEmployees().clear();
            Employee employee3Clone = (Employee)uow.registerObject((Object)this.employee[3]);
            Employee employee4Clone = (Employee)uow.registerObject((Object)this.employee[4]);
            managerClone.addManagedEmployee(employee3Clone);
            managerClone.addManagedEmployee(employee4Clone);
            uow.commit();
        }

        public void verify() {
            int i;
            long[] version = new long[this.employee.length];
            Object errorMsg = "";
            for (i = 0; i < this.employee.length; ++i) {
                version[i] = this.getVersion(this.employee[i]);
                if (version[i] == 2L) continue;
                errorMsg = (String)errorMsg + "in the cache version[" + i + "] = " + version[i] + " (2 was expected); ";
            }
            for (i = 0; i < this.employee.length; ++i) {
                this.employee[i] = (Employee)this.getSession().refreshObject((Object)this.employee[i]);
                version[i] = this.getVersion(this.employee[i]);
                if (version[i] == 2L) continue;
                errorMsg = (String)errorMsg + "in the db version[" + i + "] = " + version[i] + " (2 was expected); ";
            }
            if (((String)errorMsg).length() > 0) {
                throw new TestErrorException((String)errorMsg);
            }
        }
    }

    static class TargetLockingTest
    extends TestCase {
        Employee[] employee;

        long getVersion(Employee emp) {
            return (Long)this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)emp, (Object)emp.getId(), this.getAbstractSession());
        }

        public void reset() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            for (int i = 0; i < this.employee.length; ++i) {
                if (this.employee[i] == null) continue;
                uow.deleteObject((Object)this.employee[i]);
            }
            uow.commit();
        }
    }
}

