/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TogglingFastTableCreator
extends TableCreator {
    protected static final char TABLE_FIELD_SEPARATOR = '.';
    protected static Set<String> fastTableCreators = new HashSet<String>();
    protected static boolean useFastTableCreatorAfterInitialCreate = Boolean.getBoolean("eclipselink.test.toggle-fast-table-creator");

    public TogglingFastTableCreator() {
    }

    public TogglingFastTableCreator(Vector<TableDefinition> tableDefinitions) {
        super(tableDefinitions);
    }

    public void replaceTables(DatabaseSession session) {
        session.getSessionLog().log(1, "TogglingFastTableCreator: useFastTableCreatorAfterInitialCreate: " + useFastTableCreatorAfterInitialCreate);
        boolean isFirstCreate = !this.isFastTableCreator();
        session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - isFirstCreate: " + isFirstCreate);
        session.getSessionLog().log(1, "TogglingFastTableCreator: Current fastTableCreators: " + fastTableCreators);
        if (useFastTableCreatorAfterInitialCreate && !isFirstCreate) {
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - toggling true");
            String sequenceTableName = this.getSequenceTableName((Session)session);
            List tables = this.getTableDefinitions();
            for (TableDefinition table : tables) {
                if (table.getName().equals(sequenceTableName)) continue;
                SchemaManager schemaManager = new SchemaManager(session);
                AbstractSession abstarctSession = schemaManager.getSession();
                try {
                    abstarctSession.priviledgedExecuteNonSelectingCall((Call)new SQLCall("DELETE FROM " + table.getFullName()));
                }
                catch (DatabaseException databaseException) {}
            }
        } else {
            super.replaceTables(session);
        }
        if (useFastTableCreatorAfterInitialCreate) {
            this.setFastTableCreator();
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " added to fastTableCreators");
        }
    }

    public boolean resetFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: removing table creator: " + this.getTableCreatorName());
        return fastTableCreators.remove(this.getTableCreatorName());
    }

    public boolean setFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: adding table creator: " + this.getTableCreatorName());
        return fastTableCreators.add(this.getTableCreatorName());
    }

    public boolean isFastTableCreator() {
        return fastTableCreators.contains(this.getTableCreatorName());
    }

    public String getTableCreatorName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected static String buildFullColumnName(String tableName, String columnName) {
        StringBuilder sb = new StringBuilder(tableName.length() + columnName.length() + 1);
        sb.append(tableName).append('.').append(columnName);
        return sb.toString();
    }

    protected static TableDefinition createTable(String name) {
        TableDefinition table = new TableDefinition();
        table.setName(name);
        return table;
    }

    protected static FieldDefinition createNumericPk(String name, int size) {
        FieldDefinition field = new FieldDefinition();
        field.setName(name);
        field.setTypeName("NUMERIC");
        field.setSize(size);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(true);
        field.setIsIdentity(true);
        return field;
    }

    protected static FieldDefinition createNumericPk(String name) {
        return TogglingFastTableCreator.createNumericPk(name, 15);
    }

    protected static FieldDefinition createNumericFk(String name, int size, String fkName) {
        FieldDefinition field = new FieldDefinition();
        field.setName(name);
        field.setTypeName("NUMERIC");
        field.setSize(size);
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(false);
        field.setUnique(false);
        field.setIsIdentity(false);
        field.setForeignKeyFieldName(fkName);
        return field;
    }

    protected static FieldDefinition createNumericFk(String name, String fkName) {
        return TogglingFastTableCreator.createNumericFk(name, 15, fkName);
    }

    protected static FieldDefinition createNumericColumn(String name, int size, boolean allowNull) {
        FieldDefinition field = new FieldDefinition();
        field.setName(name);
        field.setTypeName("NUMERIC");
        field.setSize(size);
        field.setShouldAllowNull(allowNull);
        field.setIsPrimaryKey(false);
        field.setUnique(false);
        field.setIsIdentity(false);
        return field;
    }

    protected static FieldDefinition createNumericColumn(String name) {
        return TogglingFastTableCreator.createNumericColumn(name, 15, true);
    }

    protected static FieldDefinition createDTypeColumn() {
        FieldDefinition field = new FieldDefinition();
        field.setName("DTYPE");
        field.setTypeName("VARCHAR2");
        field.setSize(15);
        field.setSubSize(0);
        field.setIsPrimaryKey(false);
        field.setIsIdentity(false);
        field.setUnique(false);
        field.setShouldAllowNull(true);
        return field;
    }

    protected static FieldDefinition createStringColumn(String name, int size, boolean allowNull) {
        FieldDefinition field = new FieldDefinition();
        field.setName(name);
        field.setTypeName("VARCHAR");
        field.setSize(size);
        field.setShouldAllowNull(allowNull);
        field.setIsPrimaryKey(false);
        field.setUnique(false);
        field.setIsIdentity(false);
        return field;
    }

    protected static FieldDefinition createStringColumn(String name) {
        return TogglingFastTableCreator.createStringColumn(name, 32, true);
    }

    protected static FieldDefinition createDateColumn(String name, int size, boolean allowNull) {
        FieldDefinition field = new FieldDefinition();
        field.setName(name);
        field.setTypeName("DATE");
        field.setSize(size);
        field.setShouldAllowNull(allowNull);
        field.setIsPrimaryKey(false);
        field.setUnique(false);
        field.setIsIdentity(false);
        return field;
    }

    protected static FieldDefinition createDateColumn(String name) {
        return TogglingFastTableCreator.createDateColumn(name, 23, true);
    }

    protected void adjustForeignKeyFieldTypes(DatabaseSession session) {
        for (TableDefinition sourceTableDefinition : this.getTableDefinitions()) {
            for (FieldDefinition sourceFieldDefinition : sourceTableDefinition.getFields()) {
                if (sourceFieldDefinition.getForeignKeyFieldName() == null) continue;
                ForeignKeyConstraint foreignKeyConstraint = this.buildForeignKeyConstraint(sourceFieldDefinition, (DatabasePlatform)session.getPlatform());
                String sourceFieldName = (String)foreignKeyConstraint.getSourceFields().get(0);
                String targetFieldName = (String)foreignKeyConstraint.getTargetFields().get(0);
                TableDefinition targetTableDefinition = this.getTableDefinition(foreignKeyConstraint.getTargetTable());
                FieldDefinition targetFieldDefinition = this.getFieldDefinition(targetTableDefinition, targetFieldName);
                String qualifiedName = targetTableDefinition.getFullName() + "." + targetFieldDefinition.getName();
                if (!targetFieldDefinition.isIdentity() || !session.getPlatform().shouldPrintFieldIdentityClause((AbstractSession)session, qualifiedName)) continue;
                session.getSessionLog().log(1, "AdvancedTableCreator.adjustForeignKeyFieldTypes(): Changing data type of source field " + sourceFieldDefinition.getName() + "to INTEGER in table " + sourceTableDefinition.getName());
                sourceFieldDefinition.setTypeName("INTEGER");
                sourceFieldDefinition.setSize(0);
            }
        }
    }

    private FieldDefinition getFieldDefinition(TableDefinition tableDefinition, String fieldName) {
        for (FieldDefinition targetField : tableDefinition.getFields()) {
            if (!targetField.getName().equals(fieldName)) continue;
            return targetField;
        }
        return null;
    }

    private TableDefinition getTableDefinition(String tableName) {
        for (TableDefinition targetTable : this.getTableDefinitions()) {
            if (!targetTable.getName().equals(tableName)) continue;
            return targetTable;
        }
        return null;
    }

    private ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.add(tempSourceField.getName());
        targetFields.add(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTable().getQualifiedNameDelimited((DatasourcePlatform)platform));
        return fkConstraint;
    }
}

