/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog;

import java.nio.ByteBuffer;
import java.util.List;
import oracle.kv.impl.async.dialog.ChannelOutput;
import oracle.kv.impl.async.dialog.ProtocolMesg;

public class ProtocolWriter {
    private static final int SZ_HEADER = 1;
    private static final int SZ_MAGIC = 3;
    private static final int SZ_LONG = 9;
    private final ChannelOutput output;
    private volatile int maxMesgLen;

    public ProtocolWriter(ChannelOutput output, int maxLength) {
        this.maxMesgLen = maxLength;
        this.output = output;
    }

    public void setMaxLength(int val) {
        this.maxMesgLen = val;
    }

    public void writeProtocolVersion(int version) {
        int size = 13;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)1);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[1]);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[2]);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[3]);
        chunk.writePackedLong(version);
        chunk.done();
    }

    public void writeProtocolVersionResponse(int version) {
        int size = 13;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)2);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[1]);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[2]);
        chunk.writeByte(ProtocolMesg.MAGIC_NUMBER[3]);
        chunk.writePackedLong(version);
        chunk.done();
    }

    public void writeConnectionConfig(long uuid, long maxDialogs, long maxLength, long maxTotLen, long heartbeatInterval) {
        int size = 46;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)3);
        chunk.writePackedLong(uuid);
        chunk.writePackedLong(maxDialogs);
        chunk.writePackedLong(maxLength);
        chunk.writePackedLong(maxTotLen);
        chunk.writePackedLong(heartbeatInterval);
        chunk.done();
    }

    public void writeConnectionConfigResponse(long maxDialogs, long maxLength, long maxTotLen, long heartbeatInterval) {
        int size = 37;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)4);
        chunk.writePackedLong(maxDialogs);
        chunk.writePackedLong(maxLength);
        chunk.writePackedLong(maxTotLen);
        chunk.writePackedLong(heartbeatInterval);
        chunk.done();
    }

    public void writeNoOperation() {
        int size = 1;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)8);
        chunk.done();
    }

    public void writeConnectionAbort(ProtocolMesg.ConnectionAbort.Cause cause, String detail) {
        int size = 11;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, true);
        chunk.writeByte((byte)9);
        chunk.writeByte((byte)cause.ordinal());
        chunk.writeUTF8(detail, this.maxMesgLen);
        chunk.done();
    }

    public void writePing(long cookie) {
        int size = 10;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)10);
        chunk.writePackedLong(cookie);
        chunk.done();
    }

    public void writePingAck(long cookie) {
        int size = 10;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)11);
        chunk.writePackedLong(cookie);
        chunk.done();
    }

    public void writeDialogStart(boolean sampled, boolean finish, boolean cont, int typeno, long dialogId, long timeout, List<ByteBuffer> bytes) {
        if (finish && cont) {
            throw new IllegalArgumentException("The flags finish and cont cannot be both true in DialogStart");
        }
        this.writeDialogStartWithoutFlagCheck(sampled, finish, cont, typeno, dialogId, timeout, bytes);
    }

    public void writeDialogStartWithoutFlagCheck(boolean sampled, boolean finish, boolean cont, int typeno, long dialogId, long timeout, List<ByteBuffer> bytes) {
        byte ident = 16;
        ident = (byte)(ident | (sampled ? 4 : 0));
        ident = (byte)(ident | (finish ? 2 : 0));
        ident = (byte)(ident | (cont ? 1 : 0));
        int len = 0;
        for (ByteBuffer buf : bytes) {
            len += buf.remaining();
        }
        if (len > this.maxMesgLen) {
            throw new IllegalArgumentException(String.format("Length of the message is %d, but limit is %d", len, this.maxMesgLen));
        }
        int size = 37;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte(ident);
        chunk.writePackedLong(typeno);
        chunk.writePackedLong(dialogId);
        chunk.writePackedLong(timeout);
        chunk.writePackedLong(len);
        chunk.writeBytes(bytes);
        chunk.done();
    }

    public void writeDialogFrame(boolean finish, boolean cont, long dialogId, List<ByteBuffer> bytes) {
        if (finish && cont) {
            throw new IllegalArgumentException("The flags finish and cont cannot be both true in DialogStart");
        }
        this.writeDialogFrameWithoutFlagCheck(finish, cont, dialogId, bytes);
    }

    public void writeDialogFrameWithoutFlagCheck(boolean finish, boolean cont, long dialogId, List<ByteBuffer> bytes) {
        byte ident = 32;
        ident = (byte)(ident | (finish ? 2 : 0));
        ident = (byte)(ident | (cont ? 1 : 0));
        int len = 0;
        for (ByteBuffer buf : bytes) {
            len += buf.remaining();
        }
        if (len > this.maxMesgLen) {
            throw new IllegalArgumentException(String.format("Length of the message is %d, but limit is %d", len, this.maxMesgLen));
        }
        int size = 19;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte(ident);
        chunk.writePackedLong(dialogId);
        chunk.writePackedLong(len);
        chunk.writeBytes(bytes);
        chunk.done();
    }

    public void writeDialogAbort(ProtocolMesg.DialogAbort.Cause cause, long dialogId, String detail) {
        int size = 11;
        ChannelOutput.Chunk chunk = this.output.beginChunk(size, false);
        chunk.writeByte((byte)48);
        chunk.writeByte((byte)cause.ordinal());
        chunk.writePackedLong(dialogId);
        chunk.writeUTF8(detail, this.maxMesgLen);
        chunk.done();
    }
}

