/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.ServerIterFactory;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.TimeToLive;

public class UpdateRowIter
extends PlanIter {
    protected final String theNamespace;
    protected final String theTableName;
    protected PlanIter theInputIter;
    protected PlanIter[] theUpdateOps;
    protected boolean theUpdateTTL;
    protected PlanIter theTTLIter;
    protected TimeUnit theTTLUnit;
    protected boolean theHasReturningClause;

    public UpdateRowIter(Expr e, int resultReg, TableImpl table, PlanIter inputIter, PlanIter[] ops, boolean updateTTL, PlanIter ttlIter, TimeUnit ttlUnit, boolean hasReturningClause) {
        super(e, resultReg);
        this.theNamespace = table.getInternalNamespace();
        this.theTableName = table.getFullName();
        this.theInputIter = inputIter;
        this.theUpdateOps = ops;
        this.theUpdateTTL = updateTTL;
        this.theTTLIter = ttlIter;
        this.theTTLUnit = ttlUnit;
        assert (this.theTTLIter == null || this.theUpdateTTL);
        this.theHasReturningClause = hasReturningClause;
    }

    public UpdateRowIter(UpdateRowIter parent) {
        super(parent.theStatePos, parent.theResultReg, parent.getLocation());
        this.theNamespace = parent.theNamespace;
        this.theTableName = parent.theTableName;
        this.theInputIter = parent.theInputIter;
        this.theUpdateOps = parent.theUpdateOps;
        this.theUpdateTTL = parent.theUpdateTTL;
        this.theTTLIter = parent.theTTLIter;
        this.theTTLUnit = parent.theTTLUnit;
        this.theHasReturningClause = parent.theHasReturningClause;
    }

    public UpdateRowIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNamespace = SerializationUtil.readString(in, serialVersion);
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        this.theInputIter = UpdateRowIter.deserializeIter(in, serialVersion);
        this.theUpdateOps = UpdateRowIter.deserializeIters(in, serialVersion);
        this.theUpdateTTL = in.readBoolean();
        if (this.theUpdateTTL) {
            this.theTTLIter = UpdateRowIter.deserializeIter(in, serialVersion);
            if (this.theTTLIter != null) {
                this.theTTLUnit = TimeToLive.readTTLUnit(in, 1);
            }
        }
        this.theHasReturningClause = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.theNamespace);
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        UpdateRowIter.serializeIter(this.theInputIter, out, serialVersion);
        UpdateRowIter.serializeIters(this.theUpdateOps, out, serialVersion);
        out.writeBoolean(this.theUpdateTTL);
        if (this.theUpdateTTL) {
            UpdateRowIter.serializeIter(this.theTTLIter, out, serialVersion);
            if (this.theTTLIter != null) {
                out.writeByte((byte)this.theTTLUnit.ordinal());
            }
        }
        out.writeBoolean(this.theHasReturningClause);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.UPDATE_ROW;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        ServerIterFactory serverIterFactory = rcb.getServerIterFactory();
        PlanIter worker = serverIterFactory.createUpdateRowIter(this);
        worker.open(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        UpdateRowState state = (UpdateRowState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.theWorkerIter.close(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        UpdateRowState state = (UpdateRowState)rcb.getState(this.theStatePos);
        state.theWorkerIter.reset(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        UpdateRowState state = (UpdateRowState)rcb.getState(this.theStatePos);
        return state.theWorkerIter.next(rcb);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append("\n");
        for (int i = 0; i < this.theUpdateOps.length; ++i) {
            this.theUpdateOps[i].display(sb, formatter);
            sb.append(",\n");
        }
        formatter.indent(sb);
        sb.append("UpdateTTL = ").append(this.theUpdateTTL);
        if (this.theTTLIter != null) {
            sb.append("\n");
            this.theTTLIter.display(sb, formatter);
            sb.append("\n");
            formatter.indent(sb);
            sb.append("TimeUnit = " + (Object)((Object)this.theTTLUnit));
        }
    }

    public static class UpdateRowState
    extends PlanIterState {
        PlanIter theWorkerIter;

        public UpdateRowState(PlanIter worker) {
            this.theWorkerIter = worker;
        }
    }
}

