/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.utils.rename;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.persistence.utils.rename.RenameFileData;
import org.eclipse.persistence.utils.rename.RenameValue;

public class PackageRenamer {
    private static int BUFSIZ = 4096;
    private List<File> ignoreFiles = new ArrayList<File>();
    private List<RenameValue> renameValues = new ArrayList<RenameValue>();
    private int numberOfTotalFile = 0;
    private int numberOfChangedFile = 0;
    File sourceRootDirFile;
    File destinationRootDir;

    public PackageRenamer(String sourceFolder, String targetFolder, Properties properties) {
        this.sourceRootDirFile = this.buildAndCheckExistingDirFile(sourceFolder);
        this.destinationRootDir = this.buildAndCheckDestinationFile(targetFolder);
        this.initialize(this.sourceRootDirFile, properties);
    }

    public List<File> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public List<RenameValue> getRenameValues() {
        return this.renameValues;
    }

    public void binaryCopy(File inFile, File outFile) throws FileNotFoundException, IOException {
        int nBytesRead;
        File parentFile;
        byte[] buf = new byte[BUFSIZ];
        FileInputStream in = new FileInputStream(inFile);
        String parent = outFile.getParent();
        if (parent != null && !(parentFile = new File(parent)).exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(outFile);
        while ((nBytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, nBytesRead);
        }
        in.close();
        out.close();
    }

    private boolean bufferContainsNullChar(byte[] buffer, int bufferLength) {
        for (int i = 0; i < bufferLength; ++i) {
            if (buffer[i] != 0) continue;
            return true;
        }
        return false;
    }

    public File buildAndCheckDestinationFile(String aDirString) {
        if (aDirString == null) {
            throw new RuntimeException("Invalid destination directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (PackageRenamer.directoryIsSubdirectory(this.sourceRootDirFile, aDirFile)) {
            throw new RuntimeException("Invalid destination directory entered:  '" + aDirString + "'It cannot be a sub-directory of the source directory.");
        }
        return aDirFile;
    }

    public File buildAndCheckExistingDirFile(String aDirString) {
        if (aDirString == null) {
            throw new RuntimeException("Invalid source directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (!aDirFile.exists() || !aDirFile.isDirectory()) {
            throw new RuntimeException("Input Directory:  '" + aDirString + "'does not exist or is not a directory.");
        }
        return aDirFile;
    }

    protected static String parseFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static boolean directoryIsSubdirectory(File directory1, File directory2) {
        if (directory2 == null) {
            return false;
        }
        if (directory1.equals(directory2)) {
            return true;
        }
        return PackageRenamer.directoryIsSubdirectory(directory1, directory2.getParentFile());
    }

    public boolean isExtensionSupported(String extension) {
        return extension.equalsIgnoreCase("java") || extension.equalsIgnoreCase("xml") || extension.equalsIgnoreCase("mwp");
    }

    public void run() {
        System.out.println("LOG MESSAGES FROM packageRenamer");
        System.out.println("");
        System.out.println("INPUT: -----------------> " + this.sourceRootDirFile.toString());
        System.out.println("OUTPUT: ----------------> " + this.destinationRootDir.toString());
        System.out.println("List of changed file(s): ");
        this.traverseSourceDirectory(this.sourceRootDirFile);
        System.out.println("Total Changed File(s): ------> " + this.numberOfChangedFile);
        System.out.println("Total File(s):         ------> " + this.numberOfTotalFile);
    }

    public void runSearchAndReplacePackageName(File sourceFile) {
        if (this.getIgnoreFiles().contains(sourceFile)) {
            return;
        }
        String stringContainAllFile = "";
        String sourceFileName = sourceFile.toString();
        String sourceFileNameWithoutRoot = sourceFile.toString().substring(this.sourceRootDirFile.toString().length() + 1);
        String destinationFileNameWithoutRoot = this.renameFile(sourceFileNameWithoutRoot);
        String destinationFileName = this.destinationRootDir.toString() + File.separator + destinationFileNameWithoutRoot;
        File destFile = new File(destinationFileName);
        if (destFile.exists()) {
            System.out.println("WARNING: Skipping pre-existing: " + destFile);
            return;
        }
        System.out.print("MIGRATING: " + sourceFileName);
        try {
            FileInputStream fis = new FileInputStream(new File(sourceFileName));
            byte[] buf = new byte[BUFSIZ];
            StringBuffer strBuf = new StringBuffer((int)new File(sourceFileName).length());
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                if (this.bufferContainsNullChar(buf, i)) {
                    fis.close();
                    this.binaryCopy(sourceFile, new File(destinationFileName));
                    return;
                }
                String str = new String(buf, 0, i);
                strBuf.append(str);
            }
            fis.close();
            stringContainAllFile = new String(strBuf);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unexpected exception was thrown during file manipulation." + ioException.getMessage());
        }
        System.out.print(" -> ");
        RenameFileData fileData = new RenameFileData(stringContainAllFile, false);
        String sourcePackageName = null;
        String destPackageName = null;
        if (sourceFileNameWithoutRoot.lastIndexOf(92) >= 0) {
            sourceFileNameWithoutRoot = sourceFileNameWithoutRoot.substring(0, sourceFileNameWithoutRoot.lastIndexOf(92));
            destinationFileNameWithoutRoot = destinationFileNameWithoutRoot.substring(0, destinationFileNameWithoutRoot.lastIndexOf(92));
        }
        sourcePackageName = sourceFileNameWithoutRoot.replace('\\', '.');
        destPackageName = destinationFileNameWithoutRoot.replace('\\', '.');
        fileData = new RenameValue("package " + sourcePackageName + ";", "package " + destPackageName + ";").replace(fileData);
        for (RenameValue rv : this.getRenameValues()) {
            fileData = rv.replace(fileData);
        }
        if (fileData.isChanged()) {
            ++this.numberOfChangedFile;
        }
        System.out.println(destFile);
        try {
            destFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(destFile);
            PrintWriter out = new PrintWriter(writer);
            out.print(fileData.getFileContentsString());
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not find file to write:  '" + destinationFileName + "'" + fileNotFoundException.getMessage());
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unexpected exception was thrown while writing the file: '" + destinationFileName + "', " + ioException.getMessage());
        }
    }

    public String renameFile(String source) {
        String resourceName;
        String extension = PackageRenamer.parseFileExtension(source);
        String packageName = resourceName = source.substring(0, source.length() - (extension.length() + 1));
        if ("java".equals(extension)) {
            packageName = resourceName.replace('\\', '.');
        }
        String targetPackageName = packageName;
        RenameFileData fileData = new RenameFileData(targetPackageName, true);
        for (RenameValue rv : this.getRenameValues()) {
            fileData = rv.replace(fileData);
        }
        if ("java".equals(extension)) {
            fileData.setFileContentsString(fileData.getFileContentsString().replace('.', '\\'));
        }
        if (extension != null && extension.length() > 0) {
            fileData.setFileContentsString(fileData.getFileContentsString() + "." + extension);
        }
        return fileData.getFileContentsString();
    }

    public void traverseSourceDirectory(File directory) {
        File[] filesAndDirectories = directory.listFiles();
        for (int i = 0; i < filesAndDirectories.length; ++i) {
            File fileOrDirectory = filesAndDirectories[i];
            if (fileOrDirectory.isDirectory()) {
                if (fileOrDirectory.getName().equalsIgnoreCase(".svn")) continue;
                this.traverseSourceDirectory(fileOrDirectory);
                continue;
            }
            ++this.numberOfTotalFile;
            String fileExtension = PackageRenamer.parseFileExtension(fileOrDirectory.getName());
            if (!this.isExtensionSupported(fileExtension)) continue;
            this.runSearchAndReplacePackageName(fileOrDirectory);
        }
    }

    private void initialize(File srcRoot, Properties properties) {
        for (Object key : properties.keySet()) {
            String packageOrClassName = (String)key;
            String value = properties.getProperty(packageOrClassName);
            if (value.equalsIgnoreCase("ignore")) {
                File folder = new File(srcRoot, packageOrClassName.replace('.', '\\'));
                if (folder.exists() && folder.isDirectory()) {
                    this.addIgnoreFolder(folder, this.ignoreFiles);
                    continue;
                }
                File file = new File(srcRoot, packageOrClassName.replace('.', '\\') + ".java");
                if (!file.exists()) continue;
                this.ignoreFiles.add(file);
                continue;
            }
            this.renameValues.add(new RenameValue(packageOrClassName, value));
        }
        Collections.sort(this.renameValues, RenameValue.renameValueComparator());
    }

    private void addIgnoreFolder(File folder, List<File> ignoreFiles) {
        File[] files = folder.listFiles();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (file.isFile() && this.isExtensionSupported(PackageRenamer.parseFileExtension(file.getName()))) {
                ignoreFiles.add(file);
                continue;
            }
            if (!file.isDirectory() || file.getName().equalsIgnoreCase(".svn")) continue;
            this.addIgnoreFolder(file, ignoreFiles);
        }
    }
}

