/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.slf4j;

import java.security.AccessController;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
extends AbstractSessionLog {
    public static final String ECLIPSELINK_NAMESPACE = "org.eclipse.persistence";
    private static final LoggerCall[] loggerCall = new LoggerCall[LogLevel.length];
    private static final Logger[] categoryLoggers = new Logger[LogCategory.length];
    private final LogLevel[] logLevels;

    private static Logger getLogger(LogCategory category) {
        Logger logger = categoryLoggers[category.getId()];
        if (logger != null) {
            return logger;
        }
        Logger logger2 = LoggerFactory.getLogger((String)category.getNameSpace());
        SLF4JLogger.categoryLoggers[category.getId()] = logger2;
        return logger2;
    }

    public SLF4JLogger() {
        int defaultLevel = LogLevel.toValue((int)this.level).getId();
        this.logLevels = new LogLevel[LogCategory.length];
        block3: for (LogCategory category : LogCategory.values()) {
            byte i = category.getId();
            switch (category) {
                case ALL: {
                    this.logLevels[i] = LogLevel.toValue((int)defaultLevel);
                    continue block3;
                }
                default: {
                    String property = "eclipselink.logging.level." + category.getName();
                    String logLevelStr = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (String)AccessController.doPrivileged(new PrivilegedGetSystemProperty(property)) : System.getProperty(property);
                    this.logLevels[i] = LogLevel.toValue((int)(logLevelStr != null ? SLF4JLogger.translateStringToLoggingLevel((String)logLevelStr) : defaultLevel));
                }
            }
        }
    }

    public int getLevel() {
        return this.logLevels[LogCategory.ALL.getId()].getId();
    }

    public int getLevel(String categoryName) {
        LogCategory category = LogCategory.toValue((String)categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        return this.logLevels[category.getId()].getId();
    }

    public void setLevel(int level) {
        super.setLevel(level);
        this.logLevels[LogCategory.ALL.getId()] = LogLevel.toValue((int)level);
    }

    public void setLevel(int level, String categoryName) {
        LogCategory category = LogCategory.toValue((String)categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        this.logLevels[category.getId()] = LogLevel.toValue((int)level);
    }

    public boolean shouldLog(int level) {
        return this.logLevels[LogCategory.ALL.getId()].shouldLog((byte)level);
    }

    public boolean shouldLog(int level, String categoryName) {
        LogCategory category = LogCategory.toValue((String)categoryName);
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        return this.logLevels[category.getId()].shouldLog((byte)level);
    }

    public void log(SessionLogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        LogCategory category = LogCategory.toValue((String)logEntry.getNameSpace());
        if (category == null) {
            throw new IllegalArgumentException("Unknown logging category name.");
        }
        byte levelId = (byte)logEntry.getLevel();
        if (this.logLevels[category.getId()].shouldLog(levelId)) {
            LogLevel level = LogLevel.toValue((int)levelId);
            Logger logger = SLF4JLogger.getLogger(category);
            if (logEntry.hasException()) {
                if (this.shouldLogExceptionStackTrace()) {
                    loggerCall[level.getId()].log(logger, this.formatMessage(logEntry), logEntry.getException());
                } else {
                    loggerCall[level.getId()].log(logger, logEntry.getException().toString());
                }
            } else {
                loggerCall[level.getId()].log(logger, this.formatMessage(logEntry));
            }
        }
    }

    static {
        for (int i = 0; i < LogCategory.length; ++i) {
            SLF4JLogger.categoryLoggers[i] = null;
        }
        LogTrace logTrace = new LogTrace();
        SLF4JLogger.loggerCall[LogLevel.FINEST.getId()] = logTrace;
        SLF4JLogger.loggerCall[LogLevel.ALL.getId()] = logTrace;
        LogDebug logDebug = new LogDebug();
        SLF4JLogger.loggerCall[LogLevel.FINE.getId()] = logDebug;
        SLF4JLogger.loggerCall[LogLevel.FINER.getId()] = logDebug;
        LogInfo logInfo = new LogInfo();
        SLF4JLogger.loggerCall[LogLevel.INFO.getId()] = logInfo;
        SLF4JLogger.loggerCall[LogLevel.CONFIG.getId()] = logInfo;
        SLF4JLogger.loggerCall[LogLevel.WARNING.getId()] = new LogWarn();
        SLF4JLogger.loggerCall[LogLevel.SEVERE.getId()] = new LogError();
        SLF4JLogger.loggerCall[LogLevel.OFF.getId()] = new LogNop();
    }

    private static interface LoggerCall {
        public void log(Logger var1, String var2, Throwable var3);

        public void log(Logger var1, String var2);
    }

    private static final class LogTrace
    implements LoggerCall {
        private LogTrace() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
            logger.trace(msg, t);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.trace(message);
        }
    }

    private static final class LogDebug
    implements LoggerCall {
        private LogDebug() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
            logger.debug(msg, t);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.debug(message);
        }
    }

    private static final class LogInfo
    implements LoggerCall {
        private LogInfo() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
            logger.info(msg, t);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.info(message);
        }
    }

    private static final class LogWarn
    implements LoggerCall {
        private LogWarn() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
            logger.warn(msg, t);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.warn(message);
        }
    }

    private static final class LogError
    implements LoggerCall {
        private LogError() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
            logger.error(msg, t);
        }

        @Override
        public void log(Logger logger, String message) {
            logger.error(message);
        }
    }

    private static final class LogNop
    implements LoggerCall {
        private LogNop() {
        }

        @Override
        public void log(Logger logger, String msg, Throwable t) {
        }

        @Override
        public void log(Logger logger, String message) {
        }
    }
}

