/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.util.RateLimiting;

public class RateLimitingLogger<T> {
    private RateLimiting<T> limiter;
    private final Logger logger;

    public RateLimitingLogger(int logSamplePeriodMs, int maxObjects, Logger logger) {
        this.limiter = new RateLimiting(logSamplePeriodMs, maxObjects);
        this.logger = logger;
    }

    public long getLimitedMessageCount() {
        return this.limiter.getLimitedMessageCount();
    }

    int getMapSize() {
        return this.limiter.getMapSize();
    }

    public void log(T object, Level level, String string) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        if (object == null || this.limiter.isHandleable(object)) {
            this.logger.log(level, string);
        }
    }

    public void log(T object, Level level, Supplier<String> msgSupplier) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        if (object == null || this.limiter.isHandleable(object)) {
            this.logger.log(level, msgSupplier.get());
        }
    }

    public void log(T object, Level level, Throwable thrown, Supplier<String> msgSupplier) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        if (object == null || this.limiter.isHandleable(object)) {
            this.logger.log(level, msgSupplier.get(), thrown);
        }
    }

    public Logger getInternalLogger() {
        return this.logger;
    }
}

