/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class IndexOperation
extends InternalOperation {
    private final String indexName;
    protected final TargetTables targetTables;
    protected final IndexRange range;
    private final byte[] resumeSecondaryKey;
    private final byte[] resumePrimaryKey;
    private final int batchSize;
    private final int maxReadKB;
    private final int emptyReadFactor;

    public IndexOperation(InternalOperation.OpCode opCode, String indexName, TargetTables targetTables, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, int batchSize, int maxReadKB, int emptyReadFactor) {
        super(opCode);
        ObjectUtil.checkNull("indexName", indexName);
        ObjectUtil.checkNull("targetTables", targetTables);
        ObjectUtil.checkNull("range", range);
        if (resumeSecondaryKey != null) {
            ObjectUtil.checkNull("resumePrimaryKey", resumePrimaryKey);
        }
        this.indexName = indexName;
        this.targetTables = targetTables;
        this.range = range;
        this.resumeSecondaryKey = resumeSecondaryKey;
        this.resumePrimaryKey = resumePrimaryKey;
        this.batchSize = batchSize;
        this.maxReadKB = maxReadKB;
        assert (emptyReadFactor <= 127);
        this.emptyReadFactor = emptyReadFactor;
    }

    IndexOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.indexName = serialVersion >= 14 ? SerializationUtil.readNonNullString(in, serialVersion) : in.readUTF();
        this.targetTables = new TargetTables(in, serialVersion);
        this.range = new IndexRange(in, serialVersion);
        this.resumeSecondaryKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
        this.resumePrimaryKey = this.resumeSecondaryKey == null ? null : SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
        this.batchSize = in.readInt();
        this.maxReadKB = serialVersion >= 16 ? in.readInt() : 0;
        this.emptyReadFactor = serialVersion >= 16 ? in.readByte() : (byte)0;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeNonNullString(out, serialVersion, this.indexName);
        } else {
            out.writeUTF(this.indexName);
        }
        this.targetTables.writeFastExternal(out, serialVersion);
        this.range.writeFastExternal(out, serialVersion);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.resumeSecondaryKey);
        if (this.resumeSecondaryKey != null) {
            SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.resumePrimaryKey);
        }
        out.writeInt(this.batchSize);
        if (serialVersion >= 16) {
            out.writeInt(this.maxReadKB);
        }
        if (serialVersion >= 16) {
            out.writeByte(this.emptyReadFactor);
        }
    }

    IndexRange getIndexRange() {
        return this.range;
    }

    byte[] getResumeSecondaryKey() {
        return this.resumeSecondaryKey;
    }

    byte[] getResumePrimaryKey() {
        return this.resumePrimaryKey;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    int getMaxReadKB() {
        return this.maxReadKB;
    }

    @Override
    void addEmptyReadCharge() {
        if (this.getReadKB() == 0) {
            this.addReadBytes(1024 * this.emptyReadFactor);
        }
    }

    String getIndexName() {
        return this.indexName;
    }

    TargetTables getTargetTables() {
        return this.targetTables;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public long getTableId() {
        return this.targetTables.getTargetTableId();
    }
}

