/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FaultException;

public class RequestTimeoutException
extends FaultException {
    private static final long serialVersionUID = 1L;
    private volatile int timeoutMs;

    public RequestTimeoutException(int timeoutMs, String msg, Exception cause, boolean isRemote) {
        super(msg, cause, isRemote);
        this.timeoutMs = timeoutMs;
    }

    public RequestTimeoutException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.timeoutMs = in.readInt();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.writeFastExternal(out, serialVersion, super.getMessage());
        out.writeInt(this.timeoutMs);
    }

    @Override
    public String getMessage() {
        if (this.timeoutMs == 0) {
            return super.getMessage();
        }
        return super.getMessage() + " Timeout: " + this.timeoutMs + "ms";
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }
}

