/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class ProjectXMLDatabaseTableNameTest
extends AutoVerifyTestCase {
    private String m_tableNameAfterWrite;
    private String m_tableNameBeforeWrite;
    private static final String TABLE_NAME_QUALIFIER = "FULLY.QUALIFIED";
    private static final String TEMP_FILE = "TempProjectSafeToDelete.xml";

    public ProjectXMLDatabaseTableNameTest() {
        this.setDescription("Tests that fully qualified table names are written out.");
    }

    public void reset() {
    }

    protected void setup() throws Exception {
    }

    public void test() {
        EmployeeProject project1 = new EmployeeProject();
        this.m_tableNameBeforeWrite = project1.getDescriptor(Address.class).getTableName();
        DatabaseTable dbTable = project1.getDescriptor(Address.class).getTable(this.m_tableNameBeforeWrite);
        dbTable.setName(this.m_tableNameBeforeWrite);
        dbTable.setTableQualifier(TABLE_NAME_QUALIFIER);
        XMLProjectWriter.write((String)TEMP_FILE, (Project)project1);
        Project project2 = XMLProjectReader.read((String)TEMP_FILE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.m_tableNameAfterWrite = project2.getDescriptor(Address.class).getTable(this.m_tableNameBeforeWrite).getQualifiedName();
    }

    protected void verify() {
        if (!this.m_tableNameAfterWrite.equals("FULLY.QUALIFIED." + this.m_tableNameBeforeWrite)) {
            throw new TestErrorException("The table name was incorrectly written out. Expected: FULLY.QUALIFIED." + this.m_tableNameBeforeWrite + ", wrote: " + this.m_tableNameAfterWrite);
        }
    }
}

