/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario1_9i
extends ReportQueryTestCase {
    public Scenario1_9i() {
        this.setDescription("MIN aggregate function with group by on gender");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        BigDecimal minMale = new BigDecimal(Integer.MAX_VALUE);
        BigDecimal minFemale = new BigDecimal(Integer.MAX_VALUE);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            BigDecimal tmp;
            Employee emp = (Employee)e.nextElement();
            if (emp.getGender().equals("Male")) {
                tmp = new BigDecimal(emp.getSalary());
                if (tmp.compareTo(minMale) >= 0) continue;
                minMale = tmp;
                continue;
            }
            tmp = new BigDecimal(emp.getSalary());
            if (tmp.compareTo(minFemale) >= 0) continue;
            minFemale = tmp;
        }
        this.addResult(new Object[]{"Male", minMale}, null);
        this.addResult(new Object[]{"Female", minFemale}, null);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("gender");
        this.reportQuery.addSum("salary");
        this.reportQuery.addGrouping("gender");
    }

    @Override
    protected void verify() {
        ReportQueryResult female;
        if (this.results.size() != this.expectedResults.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size are different");
        }
        ReportQueryResult male = (ReportQueryResult)this.expectedResults.firstElement();
        if (male.getByIndex(0).equals("Male")) {
            female = (ReportQueryResult)this.expectedResults.lastElement();
        } else {
            female = male;
            male = (ReportQueryResult)this.expectedResults.lastElement();
        }
        if (!this.expectedResults.firstElement().equals(male) || !this.expectedResults.lastElement().equals(female)) {
            throw new TestErrorException("ReportQuery test failed: The results don't match");
        }
    }
}

