/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.concurrent;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.models.performance.toplink.PhoneNumber;

public class AddPhoneCachedConcurrentTest
extends ConcurrentPerformanceComparisonTest {
    protected Employee employee;
    protected int index;

    public AddPhoneCachedConcurrentTest() {
        this.setDescription("This tests the concurrency of updates.");
    }

    public synchronized int incrementIndex() {
        return this.index++;
    }

    public void setup() {
        super.setup();
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getServerSession().acquireClientSession().readObject(Employee.class, expression);
        this.index = 0;
    }

    public void runTask() throws Exception {
        ClientSession client = this.getServerSession().acquireClientSession();
        UnitOfWork uow = client.acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject((Object)this.employee);
        PhoneNumber phone = new PhoneNumber();
        int currentIndex = this.incrementIndex();
        phone.setType("new" + currentIndex);
        employee.addPhoneNumber(phone);
        uow.commit();
        uow = client.acquireUnitOfWork();
        employee = (Employee)uow.readObject((Object)employee);
        phone = (PhoneNumber)uow.readObject((Object)phone);
        employee.removePhoneNumber(phone);
        uow.commit();
        client.release();
    }
}

