/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.weaving;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.weaving.SimpleAggregate;
import org.eclipse.persistence.testing.models.weaving.SimpleObject;

public class SimpleProject
extends Project {
    public SimpleProject() {
        this.setName("SimpleProject");
        this.applyLogin();
        this.addDescriptor(this.buildSimpleObjectDescriptor());
        this.addDescriptor(this.buildSimpleAggregateDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setDatasourceLogin((Login)login);
    }

    public ClassDescriptor buildSimpleObjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SimpleObject.class);
        descriptor.addTableName("SIMPLE");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.onlyRefreshCacheIfNewerVersion();
        descriptor.setAlias("SimpleObject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping versionMapping = new DirectToFieldMapping();
        versionMapping.setAttributeName("version");
        versionMapping.setFieldName("SIMPLE.VER");
        descriptor.addMapping((DatabaseMapping)versionMapping);
        DirectToFieldMapping booleanAttributeMapping = new DirectToFieldMapping();
        booleanAttributeMapping.setAttributeName("booleanAttribute");
        booleanAttributeMapping.setFieldName("SIMPLE.BOOL_ATTRIB");
        descriptor.addMapping((DatabaseMapping)booleanAttributeMapping);
        DirectToFieldMapping charAttributeMapping = new DirectToFieldMapping();
        charAttributeMapping.setAttributeName("charAttribute");
        charAttributeMapping.setFieldName("SIMPLE.CHAR_ATTRIB");
        descriptor.addMapping((DatabaseMapping)charAttributeMapping);
        DirectToFieldMapping byteAttributeMapping = new DirectToFieldMapping();
        byteAttributeMapping.setAttributeName("byteAttribute");
        byteAttributeMapping.setFieldName("SIMPLE.BYTE_ATTRIB");
        descriptor.addMapping((DatabaseMapping)byteAttributeMapping);
        DirectToFieldMapping shortAttributeMapping = new DirectToFieldMapping();
        shortAttributeMapping.setAttributeName("shortAttribute");
        shortAttributeMapping.setFieldName("SIMPLE.SHORT_ATTRIB");
        descriptor.addMapping((DatabaseMapping)shortAttributeMapping);
        DirectToFieldMapping longAttributeMapping = new DirectToFieldMapping();
        longAttributeMapping.setAttributeName("longAttribute");
        longAttributeMapping.setFieldName("SIMPLE.LONG_ATTRIB");
        descriptor.addMapping((DatabaseMapping)longAttributeMapping);
        DirectToFieldMapping floatAttributeMapping = new DirectToFieldMapping();
        floatAttributeMapping.setAttributeName("floatAttribute");
        floatAttributeMapping.setFieldName("SIMPLE.FLOAT_ATTRIB");
        descriptor.addMapping((DatabaseMapping)floatAttributeMapping);
        DirectToFieldMapping doubleAttributeMapping = new DirectToFieldMapping();
        doubleAttributeMapping.setAttributeName("doubleAttribute");
        doubleAttributeMapping.setFieldName("SIMPLE.DOUBLE_ATTRIB");
        descriptor.addMapping((DatabaseMapping)doubleAttributeMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("SIMPLE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("name");
        firstNameMapping.setFieldName("SIMPLE.NAME");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        AggregateObjectMapping simpleAggregateMapping = new AggregateObjectMapping();
        simpleAggregateMapping.setAttributeName("simpleAggregate");
        simpleAggregateMapping.setReferenceClass(SimpleAggregate.class);
        simpleAggregateMapping.setIsNullAllowed(true);
        simpleAggregateMapping.addFieldNameTranslation("SIMPLE.FOO", "foo->DIRECT");
        descriptor.addMapping((DatabaseMapping)simpleAggregateMapping);
        return descriptor;
    }

    public ClassDescriptor buildSimpleAggregateDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(SimpleAggregate.class);
        descriptor.setAlias("SimpleAggregate");
        DirectToFieldMapping fooMapping = new DirectToFieldMapping();
        fooMapping.setAttributeName("foo");
        fooMapping.setFieldName("foo->DIRECT");
        descriptor.addMapping((DatabaseMapping)fooMapping);
        return descriptor;
    }
}

