/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.LockObject;

public class ChangeSetOptimisticLockingInsertTest
extends AutoVerifyTestCase {
    protected UnitOfWork uow;
    protected Object originalObject;
    protected Class domainClass;

    public ChangeSetOptimisticLockingInsertTest(Class aClass) {
        this.setName(this.getName() + "(" + aClass + ")");
        this.domainClass = aClass;
        this.setDescription("This test verifies that a changeset gets the correct writelock value");
    }

    protected void setup() {
        ClassDescriptor.shouldUseFullChangeSetsForNewObjects = true;
        this.beginTransaction();
        this.uow = this.getSession().acquireUnitOfWork();
        this.originalObject = this.uow.readObject(this.domainClass);
    }

    public void reset() {
        ClassDescriptor.shouldUseFullChangeSetsForNewObjects = false;
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        try {
            this.originalObject = this.domainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new TestErrorException("Failed to run test.  Unable to get new instance. " + ex.toString());
        }
        ((LockObject)this.originalObject).value = "Time:" + System.currentTimeMillis();
        this.uow.registerObject(this.originalObject);
        this.uow.commit();
    }

    protected void verify() {
        try {
            MergeManager mergeManager = new MergeManager((AbstractSession)this.getSession());
            mergeManager.mergeIntoDistributedCache();
            mergeManager.mergeChangesFromChangeSet((UnitOfWorkChangeSet)this.uow.getUnitOfWorkChangeSet());
        }
        catch (NullPointerException ex) {
            throw new TestErrorException("Threw nullpointer exception when attempting to remotely merge new object");
        }
    }
}

