/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.manual;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.ManualVerifyTestCase;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class DeleteOrderUnitOfWorkTest
extends ManualVerifyTestCase {
    public DeleteOrderUnitOfWorkTest() {
        this.setDescription("The delete order should match the following: CLAIM, POLICY, ADDRESS, HOLDER");
    }

    public void reset() {
        ClassDescriptor policyHolderDescriptor = this.getSession().getClassDescriptor(PolicyHolder.class);
        ClassDescriptor policyDescriptor = this.getSession().getClassDescriptor(Policy.class);
        OneToOneMapping addressMapping = (OneToOneMapping)policyHolderDescriptor.getMappingForAttributeName("address");
        addressMapping.setIsPrivateOwned(true);
        addressMapping.initialize(this.getAbstractSession());
        OneToManyMapping policiesMapping = (OneToManyMapping)policyHolderDescriptor.getMappingForAttributeName("policies");
        policiesMapping.setIsPrivateOwned(true);
        policiesMapping.initialize(this.getAbstractSession());
        OneToManyMapping claimsMapping = (OneToManyMapping)policyDescriptor.getMappingForAttributeName("claims");
        claimsMapping.setIsPrivateOwned(true);
        claimsMapping.initialize(this.getAbstractSession());
        this.rollbackTransaction();
    }

    protected void setup() {
        this.beginTransaction();
        ClassDescriptor policyHolderDescriptor = this.getSession().getClassDescriptor(PolicyHolder.class);
        ClassDescriptor policyDescriptor = this.getSession().getClassDescriptor(Policy.class);
        OneToOneMapping addressMapping = (OneToOneMapping)policyHolderDescriptor.getMappingForAttributeName("address");
        addressMapping.setIsPrivateOwned(false);
        addressMapping.initialize(this.getAbstractSession());
        OneToManyMapping policiesMapping = (OneToManyMapping)policyHolderDescriptor.getMappingForAttributeName("policies");
        policiesMapping.setIsPrivateOwned(false);
        policiesMapping.initialize(this.getAbstractSession());
        OneToManyMapping claimsMapping = (OneToManyMapping)policyDescriptor.getMappingForAttributeName("claims");
        claimsMapping.setIsPrivateOwned(false);
        claimsMapping.initialize(this.getAbstractSession());
    }

    protected void test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("id").equal(303);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Claim claim = (Claim)uow.readObject(Claim.class, expression);
        Policy policy = claim.getPolicy();
        PolicyHolder holder = policy.getPolicyHolder();
        Address address = holder.getAddress();
        uow.deleteObject((Object)claim);
        uow.deleteObject((Object)address);
        uow.deleteObject((Object)policy);
        uow.deleteObject((Object)holder);
        uow.commit();
    }
}

