/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestResult;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestWarningException;

public abstract class PerformanceRegressionTestCase
extends PerformanceComparisonTestCase
implements PerformanceRegressionTest {
    public static boolean reset = false;

    public PerformanceRegressionTestCase() {
        this.allowableDecrease = -5.0;
    }

    @Override
    public void verify() {
        super.verify();
        PerformanceRegressionTestCase.verify(this);
    }

    public static void verify(PerformanceRegressionTest test) {
        int numberOfRuns;
        if (reset) {
            throw new TestWarningException("Reseting baseline.");
        }
        DatabaseSession session = LoadBuildSystem.getSystem().getSession();
        ReadAllQuery query = new ReadAllQuery(TestResult.class);
        ExpressionBuilder result = new ExpressionBuilder();
        query.setSelectionCriteria(result.get("name").equal((Object)test.getName()).and(result.get("loadBuildSummary").get("machine").equal((Object)LoadBuildSystem.getSummary().getMachine())).and(result.get("loadBuildSummary").get("loginChoice").equal((Object)LoadBuildSystem.getSummary().getLoginChoice())));
        String currentVersion = LoadBuildSystem.getSummary().getToplinkVersion();
        String baselineVersion = null;
        if (System.getProperties().containsKey("toplink.loadbuild.baseline-version")) {
            baselineVersion = System.getProperties().getProperty("toplink.loadbuild.baseline-version");
            ((PerformanceComparisonTestResult)((TestCase)((Object)test)).getTestResult()).baselineVersion = baselineVersion = baselineVersion.replace('_', ' ');
        } else {
            ReportQuery reportQuery = new ReportQuery(TestResult.class, query.getExpressionBuilder());
            reportQuery.useDistinct();
            reportQuery.returnSingleValue();
            reportQuery.addAttribute("version", result.get("loadBuildSummary").get("toplinkVersion"));
            reportQuery.setSelectionCriteria(query.getSelectionCriteria().and(result.get("outcome").equal((Object)"Passed").or(result.get("outcome").equal((Object)"Warning"))).and(result.get("loadBuildSummary").get("toplinkVersion").notEqual((Object)currentVersion)));
            reportQuery.addOrdering(result.get("loadBuildSummary").get("timestamp").descending());
            baselineVersion = (String)session.executeQuery((DatabaseQuery)reportQuery);
        }
        query.setSelectionCriteria(query.getSelectionCriteria().and(result.get("loadBuildSummary").get("toplinkVersion").equal((Object)baselineVersion)));
        query.addOrdering(result.get("loadBuildSummary").get("timestamp").descending());
        query.setMaxRows(10);
        query.useCursoredStream(1, 1);
        CursoredStream stream = (CursoredStream)session.executeQuery((DatabaseQuery)query);
        if (!stream.hasMoreElements()) {
            throw new TestWarningException("No previous test result to compare performance with.");
        }
        TestResult lastResult = (TestResult)stream.nextElement();
        double lastCount = lastResult.getTestTime();
        PerformanceComparisonTestResult testResult = (PerformanceComparisonTestResult)((TestCase)((Object)test)).getTestResult();
        testResult.getBaselineVersionResults().add(lastCount);
        for (numberOfRuns = 0; stream.hasMoreElements() && numberOfRuns < 4; ++numberOfRuns) {
            TestResult nextResult = (TestResult)stream.nextElement();
            testResult.getBaselineVersionResults().add(Double.valueOf(nextResult.getTestTime()));
        }
        stream.close();
        double baselineAverage = PerformanceComparisonTestResult.averageResults(testResult.getBaselineVersionResults());
        double currentCount = ((TestCase)((Object)test)).getTestResult().getTestTime();
        testResult.baselineVersion = lastResult.getLoadBuildSummary().getToplinkVersion();
        testResult.percentageDifferenceLastRun = PerformanceComparisonTestResult.percentageDifference(currentCount, lastCount);
        query = new ReadAllQuery(TestResult.class);
        result = new ExpressionBuilder();
        query.setSelectionCriteria(result.get("name").equal((Object)test.getName()).and(result.get("loadBuildSummary").get("machine").equal((Object)LoadBuildSystem.getSummary().getMachine())).and(result.get("loadBuildSummary").get("loginChoice").equal((Object)LoadBuildSystem.getSummary().getLoginChoice())).and(result.get("loadBuildSummary").get("toplinkVersion").equal((Object)currentVersion)));
        query.addOrdering(result.get("loadBuildSummary").get("timestamp").descending());
        query.useCursoredStream(1, 1);
        stream = (CursoredStream)session.executeQuery((DatabaseQuery)query);
        testResult.getCurrentVersionResults().add(currentCount);
        for (numberOfRuns = 0; stream.hasMoreElements() && numberOfRuns < 4; ++numberOfRuns) {
            TestResult nextResult = (TestResult)stream.nextElement();
            testResult.getCurrentVersionResults().add(Double.valueOf(nextResult.getTestTime()));
        }
        stream.close();
        double currentAverage = PerformanceComparisonTestResult.averageResults(testResult.getCurrentVersionResults());
        testResult.percentageDifferenceAverage = PerformanceComparisonTestResult.percentageDifference(currentAverage, baselineAverage);
        testResult.baselineStandardDeviation = PerformanceComparisonTestResult.standardDeviationResults(testResult.getBaselineVersionResults());
        testResult.currentStandardDeviation = PerformanceComparisonTestResult.standardDeviationResults(testResult.getCurrentVersionResults());
        if (testResult.percentageDifferenceAverage < test.getAllowableDecrease()) {
            throw new TestErrorException("Test is " + (long)testResult.percentageDifferenceAverage + "% slower than last successful execution.");
        }
    }
}

