/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import org.eclipse.persistence.oxm.XMLNameTransformer;

public class DefaultXMLNameTransformer
implements XMLNameTransformer {
    private static final String EMPTY_STRING = "";
    private static final Character DOT_CHAR = Character.valueOf('.');
    private static final Character DOLLAR_SIGN_CHAR = Character.valueOf('$');

    @Override
    public String transformRootElementName(String className) {
        int idx;
        String elementName = null;
        elementName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        if (elementName.length() >= 3 && Character.isDigit(elementName.charAt((idx = elementName.length() - 1) - 1))) {
            elementName = elementName.substring(0, idx) + Character.toUpperCase(elementName.charAt(idx));
        }
        return elementName;
    }

    @Override
    public String transformTypeName(String className) {
        String typeName = EMPTY_STRING;
        typeName = className.indexOf(DOLLAR_SIGN_CHAR.charValue()) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(DOLLAR_SIGN_CHAR.charValue()) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(DOT_CHAR.charValue()) + 1));
        boolean inBreak = false;
        StringBuilder toReturn = new StringBuilder(typeName.length());
        for (int i = 0; i < typeName.length(); ++i) {
            char next = typeName.charAt(i);
            if (Character.isDigit(next)) {
                if (!inBreak) {
                    inBreak = true;
                }
                toReturn.append(next);
                continue;
            }
            if (inBreak) {
                toReturn.append(Character.toUpperCase(next));
                inBreak = false;
                continue;
            }
            toReturn.append(next);
        }
        return toReturn.toString();
    }

    private String decapitalize(String javaName) {
        int i;
        char[] name = javaName.toCharArray();
        for (i = 0; i < name.length && Character.isUpperCase(name[i]); ++i) {
        }
        if (i > 0) {
            if (name.length > i && Character.isLetter(name[i])) {
                --i;
            }
            name[0] = Character.toLowerCase(name[0]);
            for (int j = 1; j < i; ++j) {
                name[j] = Character.toLowerCase(name[j]);
            }
            return new String(name);
        }
        return javaName;
    }

    @Override
    public String transformElementName(String name) {
        return name;
    }

    @Override
    public String transformAttributeName(String name) {
        return name;
    }
}

