/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class CaseIter
extends PlanIter {
    private final PlanIter[] theCondIters;
    private final PlanIter[] theThenIters;
    private final PlanIter theElseIter;

    public CaseIter(Expr e, int resultReg, PlanIter[] condIters, PlanIter[] thenIters, PlanIter elseIter) {
        super(e, resultReg);
        this.theCondIters = condIters;
        this.theThenIters = thenIters;
        this.theElseIter = elseIter;
    }

    CaseIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theCondIters = CaseIter.deserializeIters(in, serialVersion);
        this.theThenIters = CaseIter.deserializeIters(in, serialVersion);
        this.theElseIter = CaseIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        CaseIter.serializeIters(this.theCondIters, out, serialVersion);
        CaseIter.serializeIters(this.theThenIters, out, serialVersion);
        CaseIter.serializeIter(this.theElseIter, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.CASE;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new CaseIterState());
        for (PlanIter iter : this.theCondIters) {
            iter.open(rcb);
        }
        for (PlanIter iter : this.theThenIters) {
            iter.open(rcb);
        }
        if (this.theElseIter != null) {
            this.theElseIter.open(rcb);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter iter : this.theCondIters) {
            iter.reset(rcb);
        }
        for (PlanIter iter : this.theThenIters) {
            iter.reset(rcb);
        }
        if (this.theElseIter != null) {
            this.theElseIter.reset(rcb);
        }
        CaseIterState state = (CaseIterState)rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        CaseIterState state = (CaseIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.isOpen()) {
            int i;
            for (i = 0; i < this.theCondIters.length; ++i) {
                FieldValueImpl val;
                boolean more = this.theCondIters[i].next(rcb);
                if (!more || (val = rcb.getRegVal(this.theCondIters[i].getResultReg())).isNull() || !val.getBoolean()) continue;
                state.theActiveIter = this.theThenIters[i];
                break;
            }
            if (i == this.theCondIters.length) {
                if (this.theElseIter == null) {
                    state.done();
                    return false;
                }
                state.theActiveIter = this.theElseIter;
            }
            state.setState(PlanIterState.StateEnum.RUNNING);
        }
        if (!state.theActiveIter.next(rcb)) {
            state.done();
            return false;
        }
        FieldValueImpl retValue = rcb.getRegVal(state.theActiveIter.getResultReg());
        rcb.setRegVal(this.theResultReg, retValue);
        return true;
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        CaseIterState state = (CaseIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter iter : this.theCondIters) {
            iter.close(rcb);
        }
        for (PlanIter iter : this.theThenIters) {
            iter.close(rcb);
        }
        if (this.theElseIter != null) {
            this.theElseIter.close(rcb);
        }
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        for (int i = 0; i < this.theCondIters.length; ++i) {
            formatter.indent(sb);
            sb.append("WHEN :\n");
            this.theCondIters[i].display(sb, formatter);
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("THEN :\n");
            this.theThenIters[i].display(sb, formatter);
            sb.append(",\n");
        }
        if (this.theElseIter != null) {
            formatter.indent(sb);
            sb.append("ELSE :\n");
            this.theElseIter.display(sb, formatter);
        }
    }

    private static class CaseIterState
    extends PlanIterState {
        PlanIter theActiveIter;

        private CaseIterState() {
        }
    }
}

