/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.adapters.aq;

import jakarta.resource.cci.Connection;
import java.util.Properties;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionFactory;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionSpec;

public class AQEISConnectionSpec
extends EISConnectionSpec {
    public static String URL = "url";
    public static String DATASOURCE = "datasource";

    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        this.setConnectionFactory(new AQConnectionFactory());
        String user = (String)properties.get("user");
        String password = this.getPasswordFromProperties(properties);
        String url = (String)properties.get(URL);
        String datasource = (String)properties.get(DATASOURCE);
        if (this.getConnectionSpec() == null) {
            AQConnectionSpec spec = new AQConnectionSpec(user, password, url);
            if (datasource != null) {
                spec.setDatasource(datasource);
            }
            this.setConnectionSpec(spec);
        }
        return super.connectToDataSource(accessor, properties);
    }
}

